/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.TipoContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.ContratoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ContratoRepositoryImpl
implements ContratoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContratoRepositoryImpl.class);
    private static final String WHERE_ENTIDADE = " WHERE A.ENTIDADE = :entidade ";
    private static final String CONTRATOS = "db/sql/compras/contratos.sql";
    private static final String CONTRATO_ARQUIVOS = "db/sql/compras/contratos_arquivos.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/compras/ultimaAtualizacaoContrato.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public ContratoRepositoryImpl(@Qualifier(value="wrapperCompras") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<ContratoDTO> findContratos(FindContratoParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)CONTRATOS);
        StringBuilder query = new StringBuilder(sql);
        this.condicaoContratos(query);
        this.filtro(params, query);
        StringBuilder queryCount = new StringBuilder("");
        queryCount.append("SELECT COUNT(*) FROM (");
        queryCount.append((CharSequence)query);
        queryCount.append(") X");
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY  A.TIPOATO, TIPOLIC.DESCRICAO, A.EXERCICIO DESC, L.NUMEROLICITACAO DESC, A.CONTRATO DESC");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(queryCount.toString());
            LOGGER.debug(params.toString());
        }
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List contratos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
        for (ContratoDTO contratoDTO : contratos) {
            contratoDTO.setDisplayContrato(String.format("%d/%d", contratoDTO.getNumeroContrato(), contratoDTO.getExercicio()));
            contratoDTO.setDisplayTipoContrato(contratoDTO.getTipoContrato());
            if (!contratoDTO.possuiNumeroLicitacao().booleanValue()) continue;
            contratoDTO.setDisplayLicitacao(String.format("%d/%d", contratoDTO.getNumeroLicitacao(), contratoDTO.getExercicioLicitacao()));
        }
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(contratos, pageable, total.longValue());
    }

    private void condicaoContratos(StringBuilder query) {
        query.append(WHERE_ENTIDADE);
        query.append(" AND (A.EXERCICIO = :exercicio ");
        query.append(" OR (EXTRACT(YEAR FROM A.TERMINOVIGENCIA) >= :exercicio ");
        query.append(" AND EXTRACT(YEAR FROM A.INICIOVIGENCIA) <= :exercicio) ");
        query.append(" OR (COALESCE((SELECT EXTRACT(YEAR FROM MAX(B.DATATERMINO)) ");
        query.append("FROM CLCONTRATOATOCONTRATUAL B ");
        query.append(" WHERE A.ENTIDADE = B.ENTIDADE ");
        query.append(" AND A.EXERCICIO = B.EXERCICIOCONTRATO ");
        query.append(" AND A.CONTRATO = B.CONTRATO ");
        query.append(" AND B.EXERCICIO <= :exercicio ");
        query.append(" AND B.DATATERMINO IS NOT NULL),0) >= :exercicio )) ");
        query.append(" AND A.TIPOATO  in (1,2) ");
    }

    private void filtro(FindContratoParams params, StringBuilder query) {
        params.getTipoContrato().ifPresent(tipoContrato -> query.append(" AND A.TIPOCONTRATO  = :tipoContrato "));
        params.getNumeroContrato().ifPresent(numeroContrato -> query.append(" AND A.NUMEROCONTRATO = :numeroContrato "));
        params.getNome().ifPresent(nome -> query.append(" AND  tiraacento(LOWER(B.NOME)) LIKE tiraacento(LOWER(:nome)) "));
        params.getTipoLicitacao().ifPresent(tipoLicitacao -> query.append(" AND A.TIPOLICITACAO  = :tipoLicitacao "));
        params.getExercicioLicitacao().ifPresent(exercicioLicitacao -> query.append(" AND A.EXERCICIOLICITACAO = :exercicioLicitacao "));
        params.getNumeroLicitacao().ifPresent(numeroLicitacao -> query.append(" AND L.NUMEROLICITACAO = :numeroLicitacao "));
        params.getDataInicialAssinatura().ifPresent(d -> query.append(" AND A.DATAASSINATURA >= :dataInicialAssinatura "));
        params.getDataFinalAssinatura().ifPresent(d -> query.append(" AND A.DATAASSINATURA <= :dataFinalAssinatura "));
        params.getRateio().ifPresent(d -> query.append(" AND A.RATEIO = :rateio "));
    }

    private void consoleLogger(FindContratoParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public ContratoDTO findContrato(FindContratoParams params) {
        String sql = FileUtils.readResourceAsString((String)CONTRATOS);
        String query = this.filtroFindOne(params, sql);
        this.consoleLogger(params, query);
        try {
            return (ContratoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
        }
        catch (EmptyResultDataAccessException e) {
            return new ContratoDTO();
        }
    }

    public List<ContratoArquivoDTO> findArquivos(FindContratoParams params, String nomeSchemaEloArquivo) {
        String queryContrato = this.filtroFindOne(params, FileUtils.readResourceAsString((String)CONTRATO_ARQUIVOS)).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        StringBuilder query = new StringBuilder(queryContrato);
        query.append(" AND ((P.DATA IS NOT NULL           AND P.DATA = (SELECT MIN(DATA)                           FROM CLCONTRATOPUBLICACAO P1                          WHERE P1.ENTIDADE = P.ENTIDADE                            AND P1.EXERCICIO = P.EXERCICIO                            AND P1.CONTRATO = P.CONTRATO)) OR P.DATA IS NULL)");
        this.consoleLogger(params, query.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoArquivoDTO.class));
    }

    private String filtroFindOne(FindContratoParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        query.append(WHERE_ENTIDADE);
        params.getExercicio().ifPresent(p -> query.append(" AND A.EXERCICIO = :exercicio "));
        params.getContrato().ifPresent(p -> query.append(" AND A.CONTRATO = :contrato "));
        params.getNumeroContrato().ifPresent(p -> query.append(" AND A.NUMEROCONTRATO = :numeroContrato "));
        params.getIdContrato().ifPresent(p -> query.append(" AND A.IDCONTRATO = :idContrato"));
        params.getNumeroLicitacao().ifPresent(p -> query.append(" AND L.NUMEROLICITACAO = :numeroLicitacao"));
        params.getExercicioLicitacao().ifPresent(p -> query.append(" AND A.EXERCICIOLICITACAO = :exercicioLicitacao"));
        return query.toString();
    }

    public List<TipoContratoDTO> findTiposContrato(String uf) {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT DISTINCT c.tipocontrato AS tipoContrato, c.tipocontrato AS siglaTipoContrato, e.unidadefederacao FROM clcontrato c ");
        query.append(" JOIN entidade e ON e.entidade = c.entidade ");
        query.append(" WHERE e.unidadefederacao = '");
        query.append(uf);
        query.append("' ORDER BY c.tipocontrato ASC ");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(TipoContratoDTO.class));
    }

    public List<ContratoDTO> findContratosLicitacao(FindContratoParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CONTRATOS));
        query.append(WHERE_ENTIDADE);
        query.append(" AND A.EXERCICIOLICITACAO = :exercicioLicitacao ");
        query.append(" AND A.TIPOLICITACAO = :tipoLicitacao ");
        query.append(" AND A.LICITACAO = :numeroLicitacao ");
        query.append(" AND A.TIPOATO in (1,2) ");
        this.consoleLogger(params, query.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
    }

    public ContratoDTO findContratoByIdContrato(FindContratoParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CONTRATOS));
        query.append(" WHERE A.IDCONTRATO = :contrato ");
        if (Objects.nonNull(params.getEntidade())) {
            query.append(" AND A.ENTIDADE = :entidade ");
        }
        params.getExercicio().ifPresent(item -> query.append(" AND A.EXERCICIO = :exercicio "));
        this.consoleLogger(params, query.toString());
        return (ContratoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }
}

