/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.ws.config;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.ServidorServiceWS;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.time.LocalDate;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ServidoresSchedule {
    private static final Logger LOG = LoggerFactory.getLogger(ServidoresSchedule.class);
    public static final String USA_WEB_SERVICE = "1";
    private final ServidorServiceWS servidorServiceWS;
    private final PortalParametroRepository portalParametroRepository;

    public ServidoresSchedule(ServidorServiceWS servidorServiceWS, PortalParametroRepository portalParametroRepository) {
        this.servidorServiceWS = servidorServiceWS;
        this.portalParametroRepository = portalParametroRepository;
    }

    @Scheduled(fixedDelayString="#{ ${elotech.servidor.timeToLiveMinutes:360} * 60 * 1000}")
    public void loadServidoresWS() {
        PortalParametroContabil parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_WEBSERVICE_MARINGA);
        if (Objects.nonNull(parametro) && USA_WEB_SERVICE.equals(parametro.getValor())) {
            LOG.info("AGENDAMENTO: Atualizar dados dos Servidores do WebService de Maring\u00e1");
            ServidorParams params = ServidorParams.builder().exercicio(Long.valueOf(LocalDate.now().getYear())).build();
            this.servidorServiceWS.getServidores(params);
        }
    }
}

