SELECT     
    E.EXERCICIO,
    E.MES,
    COUNT(A.TIPO) AS PEDIDOS,
    SUM(CASE WHEN A.STATUS = 'A' AND A.SITUACAO <> CAST(COALESCE(B.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS ATENDIDOS,
    SUM(CASE WHEN A.STATUS = 'A' AND A.SITUACAO = CAST(COALESCE(B.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS CANCELADOS
FROM EXERCICIO_MES E 
    LEFT OUTER JOIN PROCESSOS A 
        ON A.ENTIDADE = E.ENTIDADE 
        AND A.ANO = E.EXERCICIO
        AND EXTRACT(MONTH FROM A.DATAPROCESSO) = E.MES
        AND A.USUARIOREG = 'e-SIC'
    LEFT OUTER JOIN PARAMETROS B 
        ON B.ENTIDADE = E.ENTIDADE 
        AND B.EXERCICIO = E.EXERCICIO
        AND B.CODIGO = 91
        AND B.VALOR IS NOT NULL
        AND B.VALOR <> ''
$[FILTRO]
GROUP BY E.EXERCICIO, E.MES
ORDER BY E.EXERCICIO, E.MES


