SELECT A.BAIXADO,
       A.DATABAIXA,
       CASE A.TIPO
		WHEN 'M' THEN MB.JUSTIFICATIVA
		WHEN 'I' THEN IB.JUSTIFICATIVA
		WHEN 'V' THEN VB.JUSTIFICATIVA
       END AS JUSTIFICATIVA,
       CASE A.TIPO
        WHEN 'M' THEN MBAL.DESCRICAO
        WHEN 'I' THEN IBAL.DESCRICAO
        WHEN 'V' THEN VBAL.DESCRICAO
       END AS TIPOBAIXA
  FROM PAT_BEM A
  LEFT JOIN PAT_BEMMOVELBAIXA MB
    ON MB.ENTIDADE=A.ENTIDADE
   AND MB.TIPO=A.TIPO
   AND MB.BEM=A.BEM
   AND MB.CHAPA=A.CHAPA
   AND MB.CODIGO = (SELECT MAX(B.CODIGO)
                      FROM PAT_BEMMOVELBAIXA B
                      WHERE B.ENTIDADE=A.ENTIDADE
                        AND B.TIPO=A.TIPO
                        AND B.BEM=A.BEM
                        AND B.CHAPA=A.CHAPA)
  LEFT JOIN PAT_ALIENACAO MBAL ON MBAL.ALIENACAO = MB.ALIENACAO
  LEFT JOIN PAT_BEMVEICULOBAIXA VB
    ON VB.ENTIDADE=A.ENTIDADE
   AND VB.TIPO=A.TIPO
   AND VB.BEM=A.BEM
   AND VB.CHAPA=A.CHAPA
   AND VB.CODIGO = (SELECT MAX(B.CODIGO)
                      FROM PAT_BEMVEICULOBAIXA B
                      WHERE B.ENTIDADE=A.ENTIDADE
                        AND B.TIPO=A.TIPO
                        AND B.BEM=A.BEM
                        AND B.CHAPA=A.CHAPA)
  LEFT JOIN PAT_ALIENACAO VBAL ON VBAL.ALIENACAO = VB.ALIENACAO
  LEFT JOIN PAT_BEMIMOVELBAIXA IB
    ON IB.ENTIDADE=A.ENTIDADE
   AND IB.TIPO=A.TIPO
   AND IB.BEM=A.BEM
   AND IB.CHAPA=A.CHAPA
   AND IB.CODIGO = (SELECT MAX(B.CODIGO)
                      FROM PAT_BEMIMOVELBAIXA B
                      WHERE B.ENTIDADE=A.ENTIDADE
                        AND B.TIPO=A.TIPO
                        AND B.BEM=A.BEM
                        AND B.CHAPA=A.CHAPA)
   LEFT JOIN PAT_ALIENACAO IBAL ON IBAL.ALIENACAO = IB.ALIENACAO
  $[FILTRO] 
