CREATE OR REPLACE VIEW AISE.VW_SITUACAOFUNCIONARIO AS
SELECT F.ENTIDADE, F.MATRICULA,
CASE WHEN F.SITUACAO = 1 THEN 'ATIVO'   
       WHEN (F.SITUACAO = 2) AND (EXISTS (SELECT DISTINCT MA.ENTIDADE 
                                     FROM AISE.RHMOVIMENTACAOAFASTAMENTO MA     
                                     WHERE MA.ENTIDADE = F.ENTIDADE
                                       AND MA.MATRICULA = F.MATRICULA    
                                       AND MA.DATAINICIAL = (SELECT MAX(MA.DATAINICIAL) AS DATAINICIAL
                                                               FROM AISE.RHMOVIMENTACAOAFASTAMENTO MA     
                                                              WHERE MA.ENTIDADE = F.ENTIDADE
                                                                AND MA.MATRICULA = F.MATRICULA
                                                                AND (MA.DATAFINAL >= CURRENT_DATE OR MA.DATAFINAL IS NULL)))) THEN 'AFASTADO - ' ||   
        Coalesce((SELECT A.DESCRICAO 
                FROM AISE.RHAFASTAMENTO A   
                WHERE A.ENTIDADE = F.ENTIDADE
                AND A.AFASTAMENTO = (SELECT MAX(AFASTAMENTO) 
                                     FROM AISE.RHMOVIMENTACAOAFASTAMENTO MA     
                                     WHERE MA.ENTIDADE = F.ENTIDADE
                                       AND MA.MATRICULA = F.MATRICULA    
                                       AND MA.DATAINICIAL = (SELECT MAX(MA.DATAINICIAL) AS DATAINICIAL
                                                               FROM AISE.RHMOVIMENTACAOAFASTAMENTO MA     
                                                              WHERE MA.ENTIDADE = F.ENTIDADE
                                                                AND MA.MATRICULA = F.MATRICULA
                                                                AND (MA.DATAFINAL >= CURRENT_DATE OR MA.DATAFINAL IS NULL)))) ,' ') || ' ' ||   

        Coalesce((SELECT DISTINCT 'LICENÇA PRÊMIO'
                  FROM AISE.RHPROGRAMACAOPREMIO A    
                  WHERE A.ENTIDADE = F.ENTIDADE
                    AND A.MATRICULA = F.MATRICULA
                    AND (A.FIMPECUNIA >= CURRENT_DATE AND A.INICIOPECUNIA <= CURRENT_DATE)
                    AND (A.FIMGOZO >= CURRENT_DATE OR (A.FIMGOZO IS NULL AND A.INICIOGOZO IS NOT NULL))),' ')


      WHEN F.SITUACAO = 3 
        AND F.DATASITUACAO <= CURRENT_DATE 
        AND EXISTS (SELECT MP.ENTIDADE FROM AISE.RHMOVIMENTACAOPESSOAL MP
                     WHERE MP.ENTIDADE = F.ENTIDADE
                       AND MP.MATRICULA = F.MATRICULA
                       AND MP.TIPOMOVIMENTACAO = 7) THEN 'EXONERADO'

      WHEN F.SITUACAO = 3 
      	AND F.DATASITUACAO <= CURRENT_DATE 
      	AND (EXISTS (SELECT MP.ENTIDADE FROM AISE.RHMOVIMENTACAOPESSOAL MP
              		  WHERE MP.ENTIDADE = F.ENTIDADE 
              		    AND MP.MATRICULA = F.MATRICULA 
              		    AND (mp.tipomovimentacao IN (8, 9, 10, 11)))) THEN 'INATIVO'
            
      WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= CURRENT_DATE THEN 'DEMITIDO'
    ELSE 'ATIVO' END AS SITUACAO
FROM AISE.RHFUNCIONARIO F
