/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.RealizacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.ReceitaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ReceitaServiceImpl
implements ReceitaService {
    private final ReceitaRepository repository;

    @Autowired
    public ReceitaServiceImpl(ReceitaRepository repository) {
        this.repository = repository;
    }

    @Cacheable(value={"receitas"})
    public List<ReceitaDTO> findReceitas(FindReceitaParams params) {
        return this.repository.findReceitas(params);
    }

    @Cacheable(value={"receitas-valores"})
    public List<ReceitaDTO> findReceitaValoresDia(FindReceitaParams params) {
        return this.repository.findReceitaValoresDia(params);
    }

    public List<ReceitaDTO> findReceitasPorFonteRecurso(FindReceitaParams params) {
        return this.repository.findReceitasPorFonteRecurso(params);
    }

    public List<RealizacaoReceitaDTO> findReceitaValoresRazao(FindReceitaParams params) {
        return this.repository.findReceitaValoresRazao(params);
    }

    public Optional<ReceitaDTO> findReceita(FindReceitaParams params) {
        return this.repository.findReceita(params);
    }

    public List<ReceitaDTO> findReceitaValorMes(FindReceitaParams params) {
        return this.repository.findReceitaValorMes(params);
    }

    public List<ReceitaDTO> findReceitasDetalhada(FindReceitaParams params) {
        return this.repository.findReceitasDetalhada(params);
    }
}

