/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.QTotalAcesso;
import br.com.elotech.portaltransparencia.contabportal.domain.TotalAcesso;
import br.com.elotech.portaltransparencia.contabportal.repository.TotalAcessoRepository;
import com.querydsl.core.types.Predicate;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TotalAcessoService {
    private final TotalAcessoRepository totalAcessoRepository;

    @Autowired
    public TotalAcessoService(TotalAcessoRepository totalAcessoRepository) {
        this.totalAcessoRepository = totalAcessoRepository;
    }

    @Transactional
    public synchronized TotalAcesso getTotalAcesso() {
        TotalAcesso totalAcesso;
        Optional totalAcessoOptional = this.totalAcessoRepository.findOne((Predicate)QTotalAcesso.totalAcesso.data.eq((Object)LocalDate.now()));
        if (totalAcessoOptional.isPresent()) {
            totalAcesso = (TotalAcesso)totalAcessoOptional.get();
        } else {
            totalAcesso = new TotalAcesso();
            totalAcesso.setId(this.totalAcessoRepository.getNextId());
        }
        totalAcesso.incrementa();
        this.totalAcessoRepository.save((Object)totalAcesso);
        return TotalAcesso.builder().totalAcessos(this.totalAcessoRepository.getTotalAcessos()).build();
    }
}

