/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource.params;

import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindCedidoParams
implements AiseParams {
    private Long entidade;
    private Long exercicio;
    private Date dataAtual;
    private String nome;
    private Long tipoMovimentacao;
    private Boolean cedenteFinalizado;
    private String exportType;

    public Optional<String> getNome() {
        return Optional.ofNullable(this.nome);
    }

    public Boolean getCedenteFinalizado() {
        if (Objects.nonNull(this.cedenteFinalizado)) {
            return this.cedenteFinalizado;
        }
        return Boolean.FALSE;
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addDataAtual(params);
        this.addNome(params);
        this.addTipoMovimentacao(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addDataAtual(MapSqlParameterSource params) {
        LocalDate data = LocalDate.now();
        if (!this.anoAtual().booleanValue()) {
            data = data.withYear(this.exercicio.intValue()).with(TemporalAdjusters.lastDayOfYear());
        }
        params.addValue("dataAtual", (Object)data.toString(), 91);
    }

    private void addNome(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nome)) {
            params.addValue("nome", (Object)("%" + this.nome + "%"), 12);
        }
    }

    private void addTipoMovimentacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoMovimentacao)) {
            params.addValue("tipoMovimentacao", (Object)this.tipoMovimentacao, 2);
        }
    }

    public void setEntidadeAise(Long entidadeAise) {
        this.setEntidade(entidadeAise);
    }

    public Long getEntidadeAise() {
        return this.entidade;
    }

    private Boolean anoAtual() {
        return Long.valueOf(LocalDate.now().getYear()).equals(this.exercicio) || Objects.isNull(this.exercicio);
    }

    @Generated
    public static FindCedidoParamsBuilder builder() {
        return new FindCedidoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindCedidoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", dataAtual=" + this.getDataAtual() + ", nome=" + this.getNome() + ", tipoMovimentacao=" + this.getTipoMovimentacao() + ", cedenteFinalizado=" + this.getCedenteFinalizado() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public FindCedidoParams() {
    }

    @Generated
    public FindCedidoParams(Long entidade, Long exercicio, Date dataAtual, String nome, Long tipoMovimentacao, Boolean cedenteFinalizado, String exportType) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.dataAtual = dataAtual;
        this.nome = nome;
        this.tipoMovimentacao = tipoMovimentacao;
        this.cedenteFinalizado = cedenteFinalizado;
        this.exportType = exportType;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Date getDataAtual() {
        return this.dataAtual;
    }

    @Generated
    public Long getTipoMovimentacao() {
        return this.tipoMovimentacao;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDataAtual(Date dataAtual) {
        this.dataAtual = dataAtual;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setTipoMovimentacao(Long tipoMovimentacao) {
        this.tipoMovimentacao = tipoMovimentacao;
    }

    @Generated
    public void setCedenteFinalizado(Boolean cedenteFinalizado) {
        this.cedenteFinalizado = cedenteFinalizado;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCedidoParams)) {
            return false;
        }
        FindCedidoParams other = (FindCedidoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Date this$dataAtual = this.getDataAtual();
        Date other$dataAtual = other.getDataAtual();
        if (this$dataAtual == null ? other$dataAtual != null : !((Object)this$dataAtual).equals(other$dataAtual)) {
            return false;
        }
        Optional this$nome = this.getNome();
        Optional other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !((Object)this$nome).equals(other$nome)) {
            return false;
        }
        Long this$tipoMovimentacao = this.getTipoMovimentacao();
        Long other$tipoMovimentacao = other.getTipoMovimentacao();
        if (this$tipoMovimentacao == null ? other$tipoMovimentacao != null : !((Object)this$tipoMovimentacao).equals(other$tipoMovimentacao)) {
            return false;
        }
        Boolean this$cedenteFinalizado = this.getCedenteFinalizado();
        Boolean other$cedenteFinalizado = other.getCedenteFinalizado();
        if (this$cedenteFinalizado == null ? other$cedenteFinalizado != null : !((Object)this$cedenteFinalizado).equals(other$cedenteFinalizado)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindCedidoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Date $dataAtual = this.getDataAtual();
        result = result * 59 + ($dataAtual == null ? 43 : ((Object)$dataAtual).hashCode());
        Optional $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : ((Object)$nome).hashCode());
        Long $tipoMovimentacao = this.getTipoMovimentacao();
        result = result * 59 + ($tipoMovimentacao == null ? 43 : ((Object)$tipoMovimentacao).hashCode());
        Boolean $cedenteFinalizado = this.getCedenteFinalizado();
        result = result * 59 + ($cedenteFinalizado == null ? 43 : ((Object)$cedenteFinalizado).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }
}

