/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.repository.CGAtoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CGAtoRepositoryImpl
implements CGAtoRepository {
    private static final String LEISATOS = "db/sql/aise/leisatos.sql";
    private static final Logger LOGGER = LoggerFactory.getLogger(CGAtoRepositoryImpl.class);
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public CGAtoRepositoryImpl(@Qualifier(value="wrapperAise") DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public List<LeisAtosDTO> findLeisAtos(LeisAtosParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        if (params.getSumula().isPresent()) {
            return new ArrayList<LeisAtosDTO>();
        }
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)LEISATOS));
        params.getId().ifPresent(item -> query.append("\n   AND A.IDATO = :id "));
        params.getAno().ifPresent(item -> query.append("\n   AND A.ANOATO = :ano "));
        params.getNatureza().ifPresent(item -> query.append("\n   AND UPPER(B.DESCRICAO) LIKE UPPER(:natureza) "));
        params.getNumero().ifPresent(item -> query.append("\n   AND A.NUMEROATO = :numero "));
        params.getDescricao().ifPresent(item -> query.append("\n   AND UPPER(A.DESCRICAO) LIKE UPPER(:descricao) "));
        params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATAATO >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATAATO <= :dataFinal "));
        params.getTipoDocumentoLegal().ifPresent(item -> query.append("\n   AND TDL.CODIGO = :tipoDocumentoLegal "));
        LOGGER.debug(query.toString());
        LOGGER.debug(params.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
    }
}

