SELECT MES,
       SUM(VALOREMPENHADO) AS VALOREMPENHADO,
       SUM(VALORLIQUIDADO) AS VALORLIQUIDADO,
       SUM(VALORPAGO) AS VALORPAGO
  FROM (SELECT EX.MES,
               0 AS VALOREMPENHADO,
               0 AS VALORLIQUIDADO,
               0 AS VALORPAGO
          FROM EXERCICIO_MES EX
         WHERE EX.ENTIDADE  = :entidade
           AND EX.EXERCICIO = :exercicio
         UNION ALL
        SELECT EX.MES,
               COALESCE(F.VALOR - (F.VALORANULACOES - F.VALORESTANULACOES), 0) AS VALOREMPENHADO,
               COALESCE(F.VALORLIQUIDACOES - F.VALORESTLIQUIDACOES, 0) AS VALORLIQUIDADO,
               COALESCE(F.VALORPAGAMENTO - F.VALORESTPAGAMENTO + F.VALORRETENCOES, 0) AS VALORPAGO
          FROM EXERCICIO_MES EX
          LEFT OUTER JOIN EXERCICIO EXE
            ON EXE.ENTIDADE  = EX.ENTIDADE
           AND EXE.EXERCICIO = EX.EXERCICIO
          LEFT OUTER JOIN NIVEISMODELODESPESA NMD
            ON NMD.MODELODESPESA = EXE.MODELODESPESA
           AND NMD.TIPO          = 'P'
           AND NMD.ORDEM         = 3
          LEFT OUTER JOIN FICHAEMPENHO F
            ON F.ENTIDADE                  = EX.ENTIDADE
           AND F.EXERCICIO                 = EX.EXERCICIO
           AND EXTRACT(MONTH FROM F.DATA) <= EX.MES
          LEFT OUTER JOIN EMPENHO E
            ON E.ENTIDADE            = F.ENTIDADE
           AND E.EXERCICIO           = F.EXERCICIO
           AND E.EMPENHO             = F.EMPENHO
           AND E.UNIDADEORCAMENTARIA = F.UNIDADEORCAMENTARIA
         WHERE EX.ENTIDADE  = :entidade
           AND EX.EXERCICIO = :exercicio
           AND SUBSTR(E.PROGRAMATICA, NMD.POSICAO, NMD.TAMANHO) = '12'
           AND F.DATA <= :diasRetroativo
           AND EXISTS(SELECT F2.ENTIDADE 
                        FROM FICHAEMPENHO F2
                       WHERE F2.ENTIDADE                 = EX.ENTIDADE
                         AND F2.EXERCICIO                = EX.EXERCICIO
                         AND EXTRACT(MONTH FROM F2.DATA) = EX.MES)) X
 GROUP BY MES 
 ORDER BY MES