SELECT CENTROCUSTO, 
       CENTROCUSTODESCRICAO, 
       CAST(ITEM AS DOUBLE PRECISION),
       ITEMDESCRICAO, 
       UNIDADE, 
       SUM(QTDMOVIMENTADA) AS SALDO, 
       SUM(VALORMOVIMENTADO) AS VALORTOTAL, 
       CASE WHEN SUM(QTDMOVIMENTADA) <> 0
        THEN (SUM(VALORMOVIMENTADO) / SUM(QTDMOVIMENTADA))
        ELSE 0
       END AS CUSTOUNITARIO 
  FROM VW_ESTOQUEALMOXARIFADO 
 WHERE ENTIDADE = :entidade
   AND CENTROCUSTO = :centroCusto
   AND tiraacento(LOWER(ITEMDESCRICAO)) LIKE tiraacento(:itemDescricao) 
 GROUP BY CENTROCUSTO, CENTROCUSTODESCRICAO, 
          ITEM, ITEMDESCRICAO, UNIDADE 