/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RealizacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.ReceitaService;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/receitas"})
public class ReceitaResource {
    private final ReceitaService service;
    private final ConfiguracaoService configuracaoService;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public ReceitaResource(ReceitaService service, ConfiguracaoService configuracaoService, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.service = service;
        this.configuracaoService = configuracaoService;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping(params={"entidade", "exercicio"})
    public ResponseEntity<List<ReceitaDTO>> findReceitas(FindReceitaParams params) {
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceitas(params));
    }

    @GetMapping(value={"/detalhada"}, params={"entidade", "exercicio"})
    public ResponseEntity<List<ReceitaDTO>> findReceitasDetalhada(FindReceitaParams params) {
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceitasDetalhada(params));
    }

    @GetMapping(value={"/fonte-recursos"}, params={"entidade", "exercicio"})
    public ResponseEntity<List<ReceitaDTO>> findReceitasPorFonteRecurso(FindReceitaParams params) {
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceitasPorFonteRecurso(params));
    }

    @GetMapping(value={"/dia"}, params={"entidade", "exercicio", "receita"})
    public ResponseEntity<List<ReceitaDTO>> findReceitaValoresDia(FindReceitaParams params) {
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceitaValoresDia(params));
    }

    @GetMapping(value={"/dia"}, params={"entidade", "exercicio", "data", "receita"})
    public ResponseEntity<List<RealizacaoReceitaDTO>> findReceitaValoresRazao(FindReceitaParams params) {
        return ResponseEntity.ok((Object)this.service.findReceitaValoresRazao(params));
    }

    @GetMapping(params={"entidade", "exercicio", "receita"})
    public ResponseEntity<Optional<ReceitaDTO>> findReceita(FindReceitaParams params) {
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceita(params));
    }

    @GetMapping(value={"/grafico-anual"}, params={"entidade", "exercicio", "receita"})
    public ResponseEntity<List<ReceitaDTO>> getValoresGraficoAnualReceita(FindReceitaParams params) {
        return ResponseEntity.ok((Object)this.service.findReceitaValorMes(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findDiariasExport(HttpServletRequest request, HttpServletResponse response, FindReceitaParams params) throws Throwable {
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        List list = this.service.findReceitas(params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Receitas");
        reportParam.setClazzDTO(ReceitaDTO.class);
        reportParam.setHeaderFields("Receita,Descri\u00e7\u00e3o,Or\u00e7ado Atualizado,Arrecadado");
        reportParam.setFields("receita,descricao,valorOrcado,valorArrecadado");
        float[] fieldsPerc = new float[]{2.0f, 4.0f, 2.0f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 100, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

