/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.EstagiarioRepository;
import br.com.elotech.portaltransparencia.aiseportal.service.EstagiarioService;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EstagiarioServiceImpl
implements EstagiarioService {
    private final EstagiarioRepository estagiarioRepository;
    private final PortalParametroService portalParametroService;

    public EstagiarioServiceImpl(EstagiarioRepository estagiarioRepository, PortalParametroService portalParametroService) {
        this.estagiarioRepository = estagiarioRepository;
        this.portalParametroService = portalParametroService;
    }

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        if (this.utilizaWebService()) {
            return new PageImpl(new ArrayList());
        }
        return this.estagiarioRepository.loadEstagiarios(params, pageable);
    }

    public Optional<EstagiarioDTO> loadEstagiario(ServidorParams params) {
        Optional estagiario = this.estagiarioRepository.loadEstagiario(params);
        estagiario.ifPresent(e -> e.setDadosFinanceiros(this.estagiarioRepository.loadDadosFinanceiros(params)));
        return estagiario;
    }

    public boolean utilizaWebService() {
        String parametro = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_WEBSERVICE_MARINGA);
        return "1".equals(parametro);
    }
}

