/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.cache.ArrecadacaoBairroCacheHandler;
import br.com.elotech.portaltransparencia.aiseportal.cache.ArrecadacaoCacheHandler;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ArrecadacaoBairroDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ArrecadacaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.InadimplenciaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.ArrecadacaoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.ArrecadacaoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.ArrecadacaoService;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoServiceImpl
implements ArrecadacaoService {
    private static final int CASAS_DECIMAIS_DIVISAO = 4;
    private static final Long ENTIDADE_AISE_PADRAO = 1L;
    private final ArrecadacaoRepository repository;
    private final EntidadeAiseService entidadeAiseService;
    private final PortalParametroService parametroService;
    private ArrecadacaoBairroCacheHandler arrecadacaoBairroCacheHandler;
    private ArrecadacaoCacheHandler arrecadacaoCacheHandler;

    public ArrecadacaoServiceImpl(ArrecadacaoRepository repository, EntidadeAiseService entidadeAiseService, PortalParametroService parametroService) {
        this.repository = repository;
        this.entidadeAiseService = entidadeAiseService;
        this.parametroService = parametroService;
    }

    public List<ArrecadacaoDTO> findReceitasArrecadacao(ArrecadacaoParams params) {
        this.loadParams(params);
        params.setReceitas(this.parametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ARRECADACAO_RECEITAS));
        if (this.arrecadacaoCacheHandler == null) {
            this.arrecadacaoCacheHandler = new ArrecadacaoCacheHandler(arg_0 -> ((ArrecadacaoRepository)this.repository).findReceitasArrecadacao(arg_0));
        }
        return (List)this.arrecadacaoCacheHandler.getCache().get((Object)params);
    }

    public InadimplenciaDTO loadValoresInadimplencia(ArrecadacaoParams params) {
        List receitasArrecadacao = this.findReceitasArrecadacao(params);
        InadimplenciaDTO result = new InadimplenciaDTO();
        BigDecimal valorLancado = receitasArrecadacao.stream().map(ArrecadacaoDTO::getValorLancadoPeriodo).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        result.setValorLancado(valorLancado);
        BigDecimal valorEmAtraso = receitasArrecadacao.stream().map(ArrecadacaoDTO::getValorInadimplente).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        result.setValorEmAtraso(valorEmAtraso);
        if (valorLancado.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal valorEmAtrasoPorLancado = valorEmAtraso.divide(valorLancado, 4, RoundingMode.HALF_DOWN);
            result.setPercentual(valorEmAtrasoPorLancado.multiply(new BigDecimal("100")));
        } else {
            result.setPercentual(BigDecimal.ZERO);
        }
        return result;
    }

    public List<ArrecadacaoBairroDTO> findReceitasArrecadacaoPorBairros(ArrecadacaoParams params) {
        this.loadParams(params);
        if (this.arrecadacaoBairroCacheHandler == null) {
            this.arrecadacaoBairroCacheHandler = new ArrecadacaoBairroCacheHandler(arg_0 -> ((ArrecadacaoRepository)this.repository).findReceitasArrecadacaoPorBairros(arg_0));
        }
        return (List)this.arrecadacaoBairroCacheHandler.getCache().get((Object)params);
    }

    private void loadParams(ArrecadacaoParams params) {
        PortalParametroContabil entidadeAise = this.entidadeAiseService.getCodigoEntidadeAise(params.getEntidade());
        if (entidadeAise != null && StringUtils.isNotBlank((CharSequence)entidadeAise.getValor())) {
            params.setEntidade(Long.valueOf(Long.parseLong(entidadeAise.getValor())));
        } else {
            params.setEntidade(ENTIDADE_AISE_PADRAO);
        }
        params.setGuiasRecolhimento(this.parametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ARRECADACAO_GUIAS));
    }
}

