SELECT DISTINCT TD.DATAVALIDADE, 
       TCM.AREAUTILIZADA, 
       TCM.ATIVIDADEPRINCIPAL, 
       TCM.NUMEROALVARA,
       I.IDCADASTROGERALIMAGEM AS IDARQUIVO,
       I.MIMETYPE AS EXTENSAO
  FROM TRIBDOCUMENTO TD
  JOIN TRIBCADASTROMOBILIARIO TCM 
    ON TD.TIPOCADASTRO = TCM.TIPOCADASTRO
   AND TD.CADASTROGERAL = TCM.CADASTROGERAL
  JOIN TRIBCADASTROGERAL TCG 
    ON TCM.TIPOCADASTRO = TCG.TIPOCADASTRO
   AND TCM.CADASTROGERAL = TCG.CADASTROGERAL
  JOIN TRIBPROPRIETARIO TP 
    ON TCM.TIPOCADASTRO = TP.TIPOCADASTRO
   AND TCM.CADASTROGERAL = TP.CADASTROGERAL
  JOIN PESSOA P 
    ON TP.PESSOA = P.PESSOA
  LEFT JOIN TRIBCADASTROGERALIMAGEM I
    ON I.TIPOCADASTRO = TCG.TIPOCADASTRO
   AND I.CADASTROGERAL = TCG.CADASTROGERAL
   AND I.PESSOA = P.PESSOA
 WHERE TD.ENTIDADE = :entidade
   AND TD.EXERCICIO = :exercicio
   AND TD.TIPODOCUMENTO = 8
   AND P.PESSOA = :pessoa
 ORDER BY TD.DATAVALIDADE