SELECT ITSDCTS.ENTIDADE,
	   ITSDCTS.EXERCICIO,
	   DCT.NRO_DECRETO AS DECRETO,
       ITSDCTS.DESPESA,
       DSP.VALORPREVISTO VALORINICIAL,
       (CASE
            WHEN ITSDCTS.OPERACAO = 'S' THEN ITSDCTS.VALOR
            ELSE ITSDCTS.VALOR*-1
        END) VALOR,
       (CASE
            WHEN DCT.TIPOCREDITO = 'S' THEN 'SUPLEMENTARES'
            WHEN DCT.TIPOCREDITO = 'E' THEN 'ESPECIAL'
            WHEN DCT.TIPOCREDITO = 'X' THEN 'EXTRAORDINÁRIO'
            WHEN DCT.TIPOCREDITO = 'T' THEN 'TRANSPOSIÇÃO'
            WHEN DCT.TIPOCREDITO = 'R' THEN 'REMANEJAMENTO'
            WHEN DCT.TIPOCREDITO = 'F' THEN 'TRANSFERÊNCIA'
            ELSE ''
        END) NATUREZA,
       (DSP.VALORPREVISTO + (CASE
                                 WHEN ITSDCTS.OPERACAO = 'S' THEN ITSDCTS.VALOR
                                 ELSE ITSDCTS.VALOR*-1
                             END)) SALDOATUALIZADO
FROM
  (SELECT *
   FROM ITEMDECRETO
   WHERE ENTIDADE = :entidade
     AND EXERCICIO = :exercicio 
     $[FILTRO]) AS ITSDCTS
JOIN DECRETO DCT ON ITSDCTS.ENTIDADE = DCT.ENTIDADE
AND ITSDCTS.EXERCICIO = DCT.EXERCICIO
AND ITSDCTS.DECRETO = DCT.DECRETO
JOIN DESPESA DSP ON ITSDCTS.ENTIDADE = DSP.ENTIDADE
AND ITSDCTS.EXERCICIO = DSP.EXERCICIO
AND ITSDCTS.DESPESA = DSP.PROGRAMATICA 
$[WHERE]
ORDER BY DCT.DECRETO,
         ITSDCTS.DESPESA