
SELECT A.ENTIDADE, A.EXERCICIO, A.PRESTACAOCONTAS,
       F.NOME, A.DATA AS DATAPRESTACAO, A.EMPENHO, 
       A.EXERCICIOEMPENHO, E.DATA AS DATAEMPENHO, A.VALOREMPENHO, 
     COALESCE((SELECT SUM(VALORPAGAMENTO -VALORESTPAGAMENTO)
                            FROM FICHAEMPENHO FE 
                           WHERE FE.ENTIDADE  = A.ENTIDADE
                             AND FE.EXERCICIO = A.EXERCICIOEMPENHO
                             AND FE.EMPENHO   = A.EMPENHO),0) AS VALORPAGO,
     COALESCE((SELECT SUM(DOC.VALOR) FROM PRESTACAOCONTASDOCUMENTO DOC
        WHERE A.ENTIDADE = DOC.ENTIDADE
        AND A.EXERCICIO = DOC.EXERCICIO
        AND A.PRESTACAOCONTAS = DOC.PRESTACAOCONTAS
        AND DOC.TIPODOCUMENTO <> 99),0) AS VALORDOCUMENTOS,
     A.VALOREMPENHO - 
     COALESCE((SELECT SUM(DOC.VALOR) FROM PRESTACAOCONTASDOCUMENTO DOC
        WHERE A.ENTIDADE = DOC.ENTIDADE
        AND A.EXERCICIO = DOC.EXERCICIO
        AND A.PRESTACAOCONTAS = DOC.PRESTACAOCONTAS
        AND DOC.TIPODOCUMENTO <> 99),0) AS VALORRESTITUIDO,     
    A.CARGO,
    A.LOTACAO,
    CAST(' ' AS VARCHAR(10)) AS UNIDADEORCAMENTARIA,
    0 AS NOLIQUIDACAO,
    CAST(' ' AS VARCHAR(10)) AS MATRICULA
  FROM PRESTACAOCONTAS A
  INNER JOIN EMPENHO E ON
       A.ENTIDADE = E.ENTIDADE
       AND A.EXERCICIOEMPENHO = E.EXERCICIO
       AND A.EMPENHO = E.EMPENHO
       AND A.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
  LEFT OUTER JOIN FORNECEDOR F ON
       E.FORNECEDOR = F.FORNECEDOR
  WHERE A.ENTIDADE = :entidade
  AND A.EXERCICIO = :exercicio
  AND A.CONTABILIZADO = 'S'