SELECT F.ENTIDADE,  
      TRIM(P.NOME) AS NOME,  
      F.MATRICULA,  
      SF.SITUACAO,
      F.DATAADMISSAO,
      CASE WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= :dataAtual THEN F.DATASITUACAO ELSE NULL END AS DATADEMISSAO,
      (SELECT COALESCE(MAX(CARGOMOV.DESCRICAO), C.DESCRICAO) 
         FROM RHMOVIMENTACAOPESSOAL MP 
         LEFT OUTER JOIN RHMOVIMENTACAOOUTROS MO 
           ON MP.MOVIMENTACAO = MO.MOVIMENTACAO
          AND MP.ENTIDADE = MO.ENTIDADE
          AND MP.MATRICULA = MO.MATRICULA
         LEFT OUTER JOIN RHCARGO CARGOMOV 
           ON MO.ENTIDADE = CARGOMOV.ENTIDADE 
          AND MO.CARGO = CARGOMOV.CARGO 
        WHERE MP.MATRICULA = F.MATRICULA 
          AND MP.ENTIDADE = F.ENTIDADE
          AND MP.TIPOMOVIMENTACAO IN (59, 99)
          AND ((MO.DATAFIM IS NULL) OR (MO.DATAFIM >= :dataAtual))
          AND EXTRACT(YEAR FROM MO.DATAINICIO) <= :exercicio
      ) AS DESCRICAOCARGO,  
      CL.DESCRICAO AS DESCRICAOCLASSE,  
      RDC.DESCRICAO AS DESCRICAONATUREZA,
      RL.DESCRICAO AS DESCRICAOLOTACAO,
      COALESCE(HF.FAIXA, F.FAIXA) FAIXA,
      LOCALTRAB.DESCRICAO AS LOCALTRABALHO,
      COALESCE(F.HORASSEMANAIS, C.HORASSEMANAIS) AS HORASSEMANAIS,
      HOR.ENTRADA AS HORARIOENTRADA,
      HOR.SAIDAINTERVALO AS HORARIOSAIDAINTERVALO,
      HOR.ENTRADAINTERVALO AS HORARIOENTRADAINTERVALO,
      HOR.SAIDA AS HORARIOSAIDA,
      HOR.PERMITEFLEXIBILIDADE AS HORARIOESPECIAL,
  (SELECT COALESCE(MAX(CN.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, '')),
                   MAX(FC.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, ''))) 
     FROM RHMOVIMENTACAOPESSOAL MP
    JOIN RHTIPOMOVIMENTACAO TM
      ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
    JOIN RHMOVIMENTACAOOUTROS MO
      ON MP.ENTIDADE = MO.ENTIDADE
     AND MP.MATRICULA = MO.MATRICULA
     AND MP.MOVIMENTACAO = MO.MOVIMENTACAO
    LEFT OUTER JOIN RHCARGO CN
      ON CN.ENTIDADE = MO.ENTIDADE
     AND CN.CARGO = MO.CARGO
    LEFT OUTER JOIN RHFUNCAO FC
      ON MO.ENTIDADE = FC.ENTIDADE
     AND MO.FUNCAO = FC.FUNCAO
    WHERE F.ENTIDADE = MP.ENTIDADE
       AND F.MATRICULA = MP.MATRICULA
       AND (((MP.TIPOMOVIMENTACAO IN (59, 60, 102))
           AND (MO.OPCAOSALARIO IN ('N', 'D', 'C')))
              OR (MP.TIPOMOVIMENTACAO IN (45, 58, 99)))
               AND (MO.OPCAOSALARIO IS NULL OR MO.OPCAOSALARIO <> 'O')
               AND ((MO.DATAFIM IS NULL) OR (MO.DATAFIM > :dataAtual))
   ) NOMEACAO,
   (SELECT MAX(CASE WHEN ML.TIPOBENEFICIO = 'N' THEN 'CEDIDO SEM ÔNUS - ' || Coalesce(P.NOME,' ')
        ELSE 'CEDIDO COM ÔNUS - ' || Coalesce(P.NOME,' ') END)
     FROM RHMOVIMENTACAOPESSOAL MP
     JOIN RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN RHMOVIMENTACAOLEGAL ML
       ON MP.ENTIDADE = ML.ENTIDADE
      AND MP.MATRICULA = ML.MATRICULA
      AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
     LEFT OUTER JOIN PESSOA P
       ON ML.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 90
      AND ML.DATABENEFICIO <= (FIMCOMPETENCIA(:exercicio,12))
      AND (((:exercicio >= EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))) AND ((ML.DATATERMINO IS NULL) OR (ML.DATATERMINO > :dataAtual)))
       OR  ((:exercicio <  EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))) AND ((ML.DATATERMINO IS NULL) OR (ML.DATATERMINO >= INICIOCOMPETENCIA(:exercicio, 1)))))
   ) CEDIDO,
   (SELECT MAX(CASE WHEN MA.TIPO = '6' THEN 'CEDIDO SEM ÔNUS - ' || Coalesce(P.NOME,' ')
     ELSE 'CEDIDO COM ÔNUS - ' || Coalesce(P.NOME,' ') END)
     FROM RHMOVIMENTACAOPESSOAL MP
     JOIN RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN RHMOVIMENTACAOAFASTAMENTO MA
       ON MP.ENTIDADE = MA.ENTIDADE
      AND MP.MATRICULA = MA.MATRICULA
      AND MP.MOVIMENTACAO = MA.MOVIMENTACAO
     LEFT OUTER JOIN PESSOA P
       ON MA.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 23
      AND MA.DATAINICIAL <= (FIMCOMPETENCIA(:exercicio,12))
      AND (((:exercicio >= EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))) AND ((MA.DATAFINAL IS NULL) OR (MA.DATAFINAL > :dataAtual)))
       OR  ((:exercicio <  EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))) AND ((MA.DATAFINAL IS NULL) OR (MA.DATAFINAL >= INICIOCOMPETENCIA(:exercicio, 1)))))
   ) CEDIDOPARA,
   (SELECT COALESCE(MAX(RENOVACAOFINAL), MAX(DATAFINALCONTRATO))
      FROM RHMOVIMENTACAOPESSOAL MP
      JOIN RHCONTRATOPRAZODETERMINADO CPD
        ON MP.ENTIDADE = CPD.ENTIDADE
       AND MP.MATRICULA = CPD.MATRICULA
       AND MP.MOVIMENTACAO = CPD.MOVIMENTACAO
     WHERE MP.ENTIDADE = F.ENTIDADE
       AND MP.MATRICULA = F.MATRICULA
       AND MP.TIPOMOVIMENTACAO IN (35, 73)) DATAFIMCONTRATO,
   CASE WHEN EXISTS(SELECT 1 
                     FROM RHMOVIMENTACAOPESSOAL MP 
					WHERE MP.ENTIDADE = F.ENTIDADE 
					  AND MP.MATRICULA = F.MATRICULA 
					  AND MP.TIPOMOVIMENTACAO = 1) THEN 'Concurso Público' ELSE 'Livre Nomeação' END FORMAINVESTIDURA	   
   FROM RHFUNCIONARIO F  
   LEFT OUTER JOIN RHHISTORICOFUNCIONARIO HF
     ON F.ENTIDADE = HF.ENTIDADE
    AND F.MATRICULA = HF.MATRICULA
    AND HF.TIPOFOLHA = FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
    AND HF.ANOCOMPETENCIA = :exercicio
    AND HF.MESCOMPETENCIA = 12
   LEFT OUTER JOIN PESSOA  P   
     ON F.PESSOA = P.PESSOA  
   LEFT OUTER JOIN VW_SITUACAOFUNCIONARIO SF
     ON F.ENTIDADE = SF.ENTIDADE
     AND F.MATRICULA = SF.MATRICULA
   LEFT OUTER JOIN RHCARGO C   
     ON F.ENTIDADE = C.ENTIDADE     
    AND COALESCE(HF.CARGO, F.CARGO) = C.CARGO    
   LEFT OUTER JOIN RHCLASSE CL   
     ON F.ENTIDADE = CL.ENTIDADE     
    AND COALESCE(HF.CLASSE, F.CLASSE) = CL.CLASSE    
   LEFT OUTER JOIN RHDEFINICAOCLASSE RDC       
     ON CL.DEFINICAO = RDC.DEFINICAO     
   LEFT OUTER JOIN RHLOTACAO RL       
     ON F.ENTIDADE = RL.ENTIDADE      
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RL.MODELOLOTACAO      
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) = RL.NIVELLOTACAO      
    AND COALESCE(HF.LOTACAO, F.LOTACAO) = RL.LOTACAO  
  LEFT OUTER JOIN RHLOCALDETRABALHO LOCALTRAB
    ON COALESCE(HF.LOCALDETRABALHO, F.LOCALDETRABALHO) = LOCALTRAB.LOCALDETRABALHO
  LEFT OUTER JOIN RHHORARIOTRABALHO HOR
    ON F.ENTIDADE = HOR.ENTIDADE
   AND COALESCE(HF.HORARIOTRABALHO, F.HORARIOTRABALHO) = HOR.HORARIOTRABALHO
  WHERE F.ENTIDADE = :entidade
    AND ((F.SITUACAO <> 3) OR (F.SITUACAO = 3 AND F.DATASITUACAO >= INICIOCOMPETENCIA(:exercicio,01)))
    AND EXTRACT(YEAR FROM F.DATAADMISSAO) <= :exercicio