/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.domain.dto;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosFinanceirosDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class EstagiarioDTO {
    private static final String TIME_FORMAT = "HH:mm";
    private static final String HORARIO_ZERADO = "00:00";
    private static final String HORARIO_NULO = "--:--";
    private Long entidade;
    private String nome;
    private Long codigo;
    private String lotacao;
    private String localTrabalho;
    private LocalDateTime horarioEntrada;
    private LocalDateTime horarioSaidaIntervalo;
    private LocalDateTime horarioEntradaIntervalo;
    private LocalDateTime horarioSaida;
    private String cargo;
    private BigDecimal horasSemanais;
    private String faixa;
    private LocalDate inicioContrato;
    private LocalDate terminoContrato;
    private String horarioTrabalho;
    private List<ServidorDadosFinanceirosDTO> dadosFinanceiros;

    public String getHorarioEntradaFormated() {
        if (Objects.nonNull(this.horarioEntrada)) {
            return this.horarioEntrada.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioSaidaIntervaloFormated() {
        if (Objects.nonNull(this.horarioSaidaIntervalo)) {
            return this.horarioSaidaIntervalo.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioEntradaIntervaloFormated() {
        if (Objects.nonNull(this.horarioEntradaIntervalo)) {
            return this.horarioEntradaIntervalo.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioSaidaFormated() {
        if (Objects.nonNull(this.horarioSaida)) {
            return this.horarioSaida.format(DateTimeFormatter.ofPattern(TIME_FORMAT));
        }
        return HORARIO_NULO;
    }

    public String getHorarioTrabalho() {
        if (Objects.isNull(this.horarioEntrada) && Objects.isNull(this.horarioSaidaIntervalo) && Objects.isNull(this.horarioEntradaIntervalo) && Objects.isNull(this.horarioSaida)) {
            return this.horarioTrabalho;
        }
        if ((this.getHorarioEntradaIntervaloFormated().equals(HORARIO_ZERADO) || this.getHorarioEntradaIntervaloFormated().equals(HORARIO_NULO)) && (this.getHorarioSaidaFormated().equals(HORARIO_ZERADO) || this.getHorarioSaidaFormated().equals(HORARIO_NULO))) {
            return String.format("%s \u00e0s %s", this.getHorarioEntradaFormated(), this.getHorarioSaidaIntervaloFormated());
        }
        return String.format("%s \u00e0s %s - %s \u00e0s %s", this.getHorarioEntradaFormated(), this.getHorarioSaidaIntervaloFormated(), this.getHorarioEntradaIntervaloFormated(), this.getHorarioSaidaFormated());
    }

    @Generated
    public static EstagiarioDTOBuilder builder() {
        return new EstagiarioDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getLotacao() {
        return this.lotacao;
    }

    @Generated
    public String getLocalTrabalho() {
        return this.localTrabalho;
    }

    @Generated
    public LocalDateTime getHorarioEntrada() {
        return this.horarioEntrada;
    }

    @Generated
    public LocalDateTime getHorarioSaidaIntervalo() {
        return this.horarioSaidaIntervalo;
    }

    @Generated
    public LocalDateTime getHorarioEntradaIntervalo() {
        return this.horarioEntradaIntervalo;
    }

    @Generated
    public LocalDateTime getHorarioSaida() {
        return this.horarioSaida;
    }

    @Generated
    public String getCargo() {
        return this.cargo;
    }

    @Generated
    public BigDecimal getHorasSemanais() {
        return this.horasSemanais;
    }

    @Generated
    public String getFaixa() {
        return this.faixa;
    }

    @Generated
    public LocalDate getInicioContrato() {
        return this.inicioContrato;
    }

    @Generated
    public LocalDate getTerminoContrato() {
        return this.terminoContrato;
    }

    @Generated
    public List<ServidorDadosFinanceirosDTO> getDadosFinanceiros() {
        return this.dadosFinanceiros;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    @Generated
    public void setLocalTrabalho(String localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    @Generated
    public void setHorarioEntrada(LocalDateTime horarioEntrada) {
        this.horarioEntrada = horarioEntrada;
    }

    @Generated
    public void setHorarioSaidaIntervalo(LocalDateTime horarioSaidaIntervalo) {
        this.horarioSaidaIntervalo = horarioSaidaIntervalo;
    }

    @Generated
    public void setHorarioEntradaIntervalo(LocalDateTime horarioEntradaIntervalo) {
        this.horarioEntradaIntervalo = horarioEntradaIntervalo;
    }

    @Generated
    public void setHorarioSaida(LocalDateTime horarioSaida) {
        this.horarioSaida = horarioSaida;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setHorasSemanais(BigDecimal horasSemanais) {
        this.horasSemanais = horasSemanais;
    }

    @Generated
    public void setFaixa(String faixa) {
        this.faixa = faixa;
    }

    @Generated
    public void setInicioContrato(LocalDate inicioContrato) {
        this.inicioContrato = inicioContrato;
    }

    @Generated
    public void setTerminoContrato(LocalDate terminoContrato) {
        this.terminoContrato = terminoContrato;
    }

    @Generated
    public void setHorarioTrabalho(String horarioTrabalho) {
        this.horarioTrabalho = horarioTrabalho;
    }

    @Generated
    public void setDadosFinanceiros(List<ServidorDadosFinanceirosDTO> dadosFinanceiros) {
        this.dadosFinanceiros = dadosFinanceiros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstagiarioDTO)) {
            return false;
        }
        EstagiarioDTO other = (EstagiarioDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        String this$lotacao = this.getLotacao();
        String other$lotacao = other.getLotacao();
        if (this$lotacao == null ? other$lotacao != null : !this$lotacao.equals(other$lotacao)) {
            return false;
        }
        String this$localTrabalho = this.getLocalTrabalho();
        String other$localTrabalho = other.getLocalTrabalho();
        if (this$localTrabalho == null ? other$localTrabalho != null : !this$localTrabalho.equals(other$localTrabalho)) {
            return false;
        }
        LocalDateTime this$horarioEntrada = this.getHorarioEntrada();
        LocalDateTime other$horarioEntrada = other.getHorarioEntrada();
        if (this$horarioEntrada == null ? other$horarioEntrada != null : !((Object)this$horarioEntrada).equals(other$horarioEntrada)) {
            return false;
        }
        LocalDateTime this$horarioSaidaIntervalo = this.getHorarioSaidaIntervalo();
        LocalDateTime other$horarioSaidaIntervalo = other.getHorarioSaidaIntervalo();
        if (this$horarioSaidaIntervalo == null ? other$horarioSaidaIntervalo != null : !((Object)this$horarioSaidaIntervalo).equals(other$horarioSaidaIntervalo)) {
            return false;
        }
        LocalDateTime this$horarioEntradaIntervalo = this.getHorarioEntradaIntervalo();
        LocalDateTime other$horarioEntradaIntervalo = other.getHorarioEntradaIntervalo();
        if (this$horarioEntradaIntervalo == null ? other$horarioEntradaIntervalo != null : !((Object)this$horarioEntradaIntervalo).equals(other$horarioEntradaIntervalo)) {
            return false;
        }
        LocalDateTime this$horarioSaida = this.getHorarioSaida();
        LocalDateTime other$horarioSaida = other.getHorarioSaida();
        if (this$horarioSaida == null ? other$horarioSaida != null : !((Object)this$horarioSaida).equals(other$horarioSaida)) {
            return false;
        }
        String this$cargo = this.getCargo();
        String other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !this$cargo.equals(other$cargo)) {
            return false;
        }
        BigDecimal this$horasSemanais = this.getHorasSemanais();
        BigDecimal other$horasSemanais = other.getHorasSemanais();
        if (this$horasSemanais == null ? other$horasSemanais != null : !((Object)this$horasSemanais).equals(other$horasSemanais)) {
            return false;
        }
        String this$faixa = this.getFaixa();
        String other$faixa = other.getFaixa();
        if (this$faixa == null ? other$faixa != null : !this$faixa.equals(other$faixa)) {
            return false;
        }
        LocalDate this$inicioContrato = this.getInicioContrato();
        LocalDate other$inicioContrato = other.getInicioContrato();
        if (this$inicioContrato == null ? other$inicioContrato != null : !((Object)this$inicioContrato).equals(other$inicioContrato)) {
            return false;
        }
        LocalDate this$terminoContrato = this.getTerminoContrato();
        LocalDate other$terminoContrato = other.getTerminoContrato();
        if (this$terminoContrato == null ? other$terminoContrato != null : !((Object)this$terminoContrato).equals(other$terminoContrato)) {
            return false;
        }
        String this$horarioTrabalho = this.getHorarioTrabalho();
        String other$horarioTrabalho = other.getHorarioTrabalho();
        if (this$horarioTrabalho == null ? other$horarioTrabalho != null : !this$horarioTrabalho.equals(other$horarioTrabalho)) {
            return false;
        }
        List this$dadosFinanceiros = this.getDadosFinanceiros();
        List other$dadosFinanceiros = other.getDadosFinanceiros();
        return !(this$dadosFinanceiros == null ? other$dadosFinanceiros != null : !((Object)this$dadosFinanceiros).equals(other$dadosFinanceiros));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EstagiarioDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        String $lotacao = this.getLotacao();
        result = result * 59 + ($lotacao == null ? 43 : $lotacao.hashCode());
        String $localTrabalho = this.getLocalTrabalho();
        result = result * 59 + ($localTrabalho == null ? 43 : $localTrabalho.hashCode());
        LocalDateTime $horarioEntrada = this.getHorarioEntrada();
        result = result * 59 + ($horarioEntrada == null ? 43 : ((Object)$horarioEntrada).hashCode());
        LocalDateTime $horarioSaidaIntervalo = this.getHorarioSaidaIntervalo();
        result = result * 59 + ($horarioSaidaIntervalo == null ? 43 : ((Object)$horarioSaidaIntervalo).hashCode());
        LocalDateTime $horarioEntradaIntervalo = this.getHorarioEntradaIntervalo();
        result = result * 59 + ($horarioEntradaIntervalo == null ? 43 : ((Object)$horarioEntradaIntervalo).hashCode());
        LocalDateTime $horarioSaida = this.getHorarioSaida();
        result = result * 59 + ($horarioSaida == null ? 43 : ((Object)$horarioSaida).hashCode());
        String $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : $cargo.hashCode());
        BigDecimal $horasSemanais = this.getHorasSemanais();
        result = result * 59 + ($horasSemanais == null ? 43 : ((Object)$horasSemanais).hashCode());
        String $faixa = this.getFaixa();
        result = result * 59 + ($faixa == null ? 43 : $faixa.hashCode());
        LocalDate $inicioContrato = this.getInicioContrato();
        result = result * 59 + ($inicioContrato == null ? 43 : ((Object)$inicioContrato).hashCode());
        LocalDate $terminoContrato = this.getTerminoContrato();
        result = result * 59 + ($terminoContrato == null ? 43 : ((Object)$terminoContrato).hashCode());
        String $horarioTrabalho = this.getHorarioTrabalho();
        result = result * 59 + ($horarioTrabalho == null ? 43 : $horarioTrabalho.hashCode());
        List $dadosFinanceiros = this.getDadosFinanceiros();
        result = result * 59 + ($dadosFinanceiros == null ? 43 : ((Object)$dadosFinanceiros).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EstagiarioDTO(entidade=" + this.getEntidade() + ", nome=" + this.getNome() + ", codigo=" + this.getCodigo() + ", lotacao=" + this.getLotacao() + ", localTrabalho=" + this.getLocalTrabalho() + ", horarioEntrada=" + this.getHorarioEntrada() + ", horarioSaidaIntervalo=" + this.getHorarioSaidaIntervalo() + ", horarioEntradaIntervalo=" + this.getHorarioEntradaIntervalo() + ", horarioSaida=" + this.getHorarioSaida() + ", cargo=" + this.getCargo() + ", horasSemanais=" + this.getHorasSemanais() + ", faixa=" + this.getFaixa() + ", inicioContrato=" + this.getInicioContrato() + ", terminoContrato=" + this.getTerminoContrato() + ", horarioTrabalho=" + this.getHorarioTrabalho() + ", dadosFinanceiros=" + this.getDadosFinanceiros() + ")";
    }

    @Generated
    public EstagiarioDTO(Long entidade, String nome, Long codigo, String lotacao, String localTrabalho, LocalDateTime horarioEntrada, LocalDateTime horarioSaidaIntervalo, LocalDateTime horarioEntradaIntervalo, LocalDateTime horarioSaida, String cargo, BigDecimal horasSemanais, String faixa, LocalDate inicioContrato, LocalDate terminoContrato, String horarioTrabalho, List<ServidorDadosFinanceirosDTO> dadosFinanceiros) {
        this.entidade = entidade;
        this.nome = nome;
        this.codigo = codigo;
        this.lotacao = lotacao;
        this.localTrabalho = localTrabalho;
        this.horarioEntrada = horarioEntrada;
        this.horarioSaidaIntervalo = horarioSaidaIntervalo;
        this.horarioEntradaIntervalo = horarioEntradaIntervalo;
        this.horarioSaida = horarioSaida;
        this.cargo = cargo;
        this.horasSemanais = horasSemanais;
        this.faixa = faixa;
        this.inicioContrato = inicioContrato;
        this.terminoContrato = terminoContrato;
        this.horarioTrabalho = horarioTrabalho;
        this.dadosFinanceiros = dadosFinanceiros;
    }

    @Generated
    public EstagiarioDTO() {
    }
}

