/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.admportal.domain.PerguntaFrequente;
import br.com.elotech.portaltransparencia.admportal.domain.PerguntaFrequentePK;
import br.com.elotech.portaltransparencia.admportal.domain.dto.PerguntaFrequenteDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.PerguntaFrequenteConverter;
import br.com.elotech.portaltransparencia.admportal.service.PerguntaFrequenteService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/perguntas-frequentes", "/admin/perguntas-frequentes"})
public class PerguntaFrequenteResource {
    private final PerguntaFrequenteService perguntaFrequenteService;
    private final BaseExport baseExport;

    public PerguntaFrequenteResource(PerguntaFrequenteService perguntaFrequenteService, BaseExport baseExport) {
        this.perguntaFrequenteService = perguntaFrequenteService;
        this.baseExport = baseExport;
    }

    @GetMapping
    public ResponseEntity<List<PerguntaFrequente>> findByEntidade(@RequestHeader(value="entidade") Long entidade, @RequestParam(value="filtro") String filtro) {
        return ResponseEntity.ok((Object)this.perguntaFrequenteService.findByEntidadeAndFiltro(entidade, filtro));
    }

    @GetMapping(value={"/report/{exportType}"})
    public ModelAndView findByEntidadeExport(@PathVariable String exportType, @RequestHeader(value="entidade") Long entidade, @RequestParam(value="filtro") String filtro, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ReportParam param = new ReportParam();
        param.setReportTitle("Listagem de Perguntas Frequentes");
        param.setClazzDTO(PerguntaFrequente.class);
        param.setFields("pergunta,resposta");
        float[] fieldsPerc = new float[]{6.0f, 4.0f};
        param.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{300, 200};
        param.setWidthsFieldsTab(fieldTab);
        param.setItems(this.perguntaFrequenteService.findByEntidadeAndFiltro(entidade, filtro));
        param.setRequest(request);
        param.setResponse(response);
        param.setReportType(exportType);
        return this.baseExport.toExport(param);
    }

    @GetMapping(value={"/entidade/{entidade}"})
    public ResponseEntity<Page<PerguntaFrequenteDTO>> findByEntidade(@PathVariable(value="entidade") Long entidade, Pageable page) {
        return ResponseEntity.ok((Object)this.perguntaFrequenteService.findByEntidade(entidade, page).map(PerguntaFrequenteConverter::toDTO));
    }

    @PostMapping
    public ResponseEntity<PerguntaFrequenteDTO> save(@RequestBody PerguntaFrequenteDTO perguntaDTO) throws URISyntaxException {
        PerguntaFrequente saved = this.perguntaFrequenteService.save(PerguntaFrequenteConverter.toEntity((PerguntaFrequenteDTO)perguntaDTO));
        return ResponseEntity.created((URI)new URI("")).body((Object)PerguntaFrequenteConverter.toDTO((PerguntaFrequente)saved));
    }

    @PutMapping(params={"id", "entidade"})
    public ResponseEntity<PerguntaFrequenteDTO> update(@RequestBody PerguntaFrequenteDTO perguntaDTO, Long id, Long entidade) {
        PerguntaFrequentePK pk = new PerguntaFrequentePK(entidade, id);
        PerguntaFrequente pergunta = this.perguntaFrequenteService.findOne(pk);
        if (Objects.isNull(pergunta)) {
            throw RestException.notFound();
        }
        PerguntaFrequenteConverter.insertDTOtoEntity((PerguntaFrequenteDTO)perguntaDTO, (PerguntaFrequente)pergunta);
        return ResponseEntity.ok((Object)PerguntaFrequenteConverter.toDTO((PerguntaFrequente)this.perguntaFrequenteService.save(pergunta)));
    }

    @DeleteMapping(params={"id", "entidade"})
    public ResponseEntity<Void> remove(Long id, Long entidade) {
        PerguntaFrequentePK pk = new PerguntaFrequentePK(entidade, id);
        PerguntaFrequente pergunta = this.perguntaFrequenteService.findOne(pk);
        if (Objects.isNull(pergunta)) {
            return ResponseEntity.notFound().build();
        }
        this.perguntaFrequenteService.remove(pergunta);
        return ResponseEntity.ok().build();
    }

    @GetMapping(params={"id", "entidade"})
    public ResponseEntity<PerguntaFrequenteDTO> findOne(Long id, Long entidade) {
        PerguntaFrequentePK pk = new PerguntaFrequentePK(entidade, id);
        PerguntaFrequente perguntaFrequente = this.perguntaFrequenteService.findOne(pk);
        if (Objects.isNull(perguntaFrequente)) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)PerguntaFrequenteConverter.toDTO((PerguntaFrequente)perguntaFrequente));
    }
}

