SELECT R.FONTERECURSO AS RECEITA, F.DESCRICAO,
       COALESCE(SUM(R.VALORORCADO),0) AS VALORORCADO,
       (COALESCE(SUM(R.VALORORCADO),0) +
       COALESCE(SUM((SELECT SUM(RECM.VALORCORRECAOORCADO) 
                       FROM RECEITAMENSAL RECM
                      WHERE R.ENTIDADE = RECM.ENTIDADE
                        AND R.EXERCICIO = RECM.EXERCICIO
                        AND R.RECEITA = RECM.RECEITA
                        AND R.FONTERECURSO = RECM.FONTERECURSO
                        AND R.IDTIPOOPERACAORECEITA = RECM.IDTIPOOPERACAORECEITA
                        AND RECM.MES <= :mesDiasRetroativos)),0)) AS VALORATUALIZADO,
       COALESCE(SUM((SELECT SUM(RD.VALORARRECADADO - RD.VALORESTARRECADADO - RD.VALORDEVOLUCAO + RD.VALORESTDEVOLUCAO)
                       FROM RECEITADIARIA RD
                      WHERE R.ENTIDADE = RD.ENTIDADE
                        AND R.EXERCICIO = RD.EXERCICIO
                        AND R.RECEITA = RD.RECEITA
                        AND R.FONTERECURSO = RD.FONTERECURSO
                        AND R.IDTIPOOPERACAORECEITA = RD.IDTIPOOPERACAORECEITA
                        AND RD.DATA <= :diasRetroativo)),0) AS VALORARRECADADO
  FROM RECEITA R
  LEFT JOIN FONTERECURSO F
    ON F.FONTERECURSO = R.FONTERECURSO
 WHERE R.ENTIDADE = :entidade
   AND R.EXERCICIO = :exercicio
   AND R.MOVSN = 'S'
 GROUP BY R.FONTERECURSO, F.DESCRICAO
 ORDER BY R.FONTERECURSO, F.DESCRICAO