SELECT CF.ENTIDADE, CF.CARGO, CF.QUADROSALARIAL, CF.GRUPOOCUPACIONAL, CF.NIVEL, 
       GOF.FAIXA, GOF.DESCRICAO AS FAIXADESC, GOF.VALOR, GOF.VALORGRATIFICACAO,
       C.DESCRICAO, CL.DESCRICAO AS TIPO, CF.QUADROSALARIAL, QS.DESCRICAO AS QUADROSALARIALDESC,
       GO.DESCRICAO AS GRUPOOCUPACIONALDESC, GN.DESCRICAO AS NIVELDESC, C.VAGAS AS VAGASTOTAL,
       C.OCUPADAS AS VAGASOCUPADAS
  FROM RHCARGOFAIXA CF
 INNER JOIN RHCARGO C 
    ON CF.ENTIDADE = C.ENTIDADE
   AND CF.CARGO = C.CARGO  
  LEFT OUTER JOIN RHCLASSIFICACAOCARGO CL
    ON CL.CLASSIFICACAO = C.CLASSIFICACAO
  LEFT OUTER JOIN RHQUADROSALARIAL QS
    ON CF.ENTIDADE = QS.ENTIDADE
   AND CF.QUADROSALARIAL = QS.QUADROSALARIAL
  LEFT OUTER JOIN RHGRUPOOCUPACIONAL GO
    ON CF.ENTIDADE = GO.ENTIDADE
   AND CF.QUADROSALARIAL = GO.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GO.GRUPOOCUPACIONAL
  LEFT OUTER JOIN RHGRUPOOCUPACIONALNIVEL GN
    ON CF.ENTIDADE = GN.ENTIDADE
   AND CF.QUADROSALARIAL = GN.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GN.GRUPOOCUPACIONAL
   AND GN.NIVEL BETWEEN CF.NIVEL AND CF.NIVELFINAL
  LEFT OUTER JOIN RHGRUPOOCUPACIONALFAIXA GOF  
    ON CF.ENTIDADE = GOF.ENTIDADE
   AND CF.QUADROSALARIAL = GOF.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
   AND CF.NIVEL = GOF.NIVEL
 WHERE CF.ENTIDADE = :entidade
   AND FNC_GETNUMEROFAIXA(GOF.FAIXA, CF.PADRAONIVELINICIAL) >= FNC_GETNUMEROFAIXA(CF.FAIXAINICIAL, CF.PADRAONIVELINICIAL) 
   AND FNC_GETNUMEROFAIXA(GOF.FAIXA, CF.PADRAONIVELINICIAL) <= FNC_GETNUMEROFAIXA(CF.FAIXAFINAL, CF.PADRAONIVELINICIAL) 
   AND CF.INICIOVALIDADE = (SELECT MAX(X.INICIOVALIDADE) 
                              FROM RHCARGOFAIXA X 
                             WHERE X.ENTIDADE = CF.ENTIDADE 
                               AND X.CARGO = CF.CARGO 
                               AND EXTRACT(YEAR FROM X.INICIOVALIDADE) <= :exercicio)
   AND GOF.INICIOVALIDADE = (SELECT MAX(GOFX.INICIOVALIDADE)
                               FROM RHGRUPOOCUPACIONALFAIXA GOFX
                               JOIN RHGRUPOOCUPACIONALCOMPETENCIA GOCX ON GOFX.ENTIDADE = GOCX.ENTIDADE
                                AND GOFX.QUADROSALARIAL = GOCX.QUADROSALARIAL
                                AND GOFX.GRUPOOCUPACIONAL = GOCX.GRUPOOCUPACIONAL
                                AND GOFX.NIVEL = GOCX.NIVEL
                                AND GOFX.INICIOVALIDADE = GOCX.INICIOVALIDADE
                              WHERE GOFX.ENTIDADE = GOF.ENTIDADE
                                AND GOFX.QUADROSALARIAL = GOF.QUADROSALARIAL
                                AND GOFX.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
                                AND GOFX.NIVEL = GOF.NIVEL
                                AND GOFX.FAIXA = GOF.FAIXA
                                AND GOCX.SITUACAO = 1
                                AND EXTRACT(YEAR FROM GOFX.INICIOVALIDADE) <= :exercicio)