/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.caelum.stella.type.Estado;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.service.NadItemPercentualService;
import br.com.elotech.portaltransparencia.contabportal.domain.Empenho;
import br.com.elotech.portaltransparencia.contabportal.domain.FichaEmpenho;
import br.com.elotech.portaltransparencia.contabportal.domain.NivelModeloDespesa;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnexosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnulacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDocumentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoMovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRetencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioEmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.ComprasDiretaToDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.EmpenhoToDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EmpenhoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.NivelModeloDespesaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.PatrimonioMovimentoEmpenhoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ProgramaticaParams;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EmpenhoService {
    private static final String EXERCICIO = "exercicio";
    private static final String EMPENHO = "empenho";
    private static final String ID = "id";
    private static final String SIM = "S";
    private static final String PROGRAMATICA = "programatica";
    private static final String TIPO_P = "P";
    private static final String TIPO_C = "C";
    private static final int NIVEL_1 = 1;
    private static final int NIVEL_2 = 2;
    private static final int NIVEL_3 = 3;
    private static final int NIVEL_4 = 4;
    private static final int NIVEL_5 = 5;
    private static final int NIVEL_6 = 6;
    private static final int NIVEL_7 = 7;
    private static final BigDecimal EPSILON = new BigDecimal("0.001");
    private static final Long MODELODESPESA = 3L;
    private static final Integer POSICAO_NATUREZA = 23;
    private static final Integer TAMANHO_NATUREZA = 2;
    private static final Integer TAMANHO_ELEMENTO_RO = 6;
    private static final String FONTE_RECURSO = "fonteRecurso";
    private final EmpenhoRepository empenhoRepository;
    private final NivelModeloDespesaRepository nivelModeloDespesaRepository;
    private final PatrimonioMovimentoEmpenhoRepository patrimonioMovRepository;
    private final ArquivoService arquivoService;
    private final EntidadeContabilidadeService entidadeService;
    private final EntityManager em;
    private final NadItemPercentualService nadItemPercentualService;

    @Autowired
    public EmpenhoService(EmpenhoRepository empenhoRepository, NivelModeloDespesaRepository nivelModeloDespesaRepository, PatrimonioMovimentoEmpenhoRepository patrimonioMovRepository, ArquivoService arquivoService, EntidadeContabilidadeService entidadeService, NadItemPercentualService nadItemPercentualService, @Qualifier(value="entityManager") EntityManager em) {
        this.empenhoRepository = empenhoRepository;
        this.nivelModeloDespesaRepository = nivelModeloDespesaRepository;
        this.patrimonioMovRepository = patrimonioMovRepository;
        this.arquivoService = arquivoService;
        this.entidadeService = entidadeService;
        this.em = em;
        this.nadItemPercentualService = nadItemPercentualService;
    }

    public Page<EmpenhosListaDTO> getEmpenhosSearch(Pageable pageable, EmpenhoParams params) {
        PageRequest page = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(new Sort(Sort.Direction.DESC, new String[]{"data", "id.empenho"})));
        Specification specification = this.getSpecificationEmpenho(params);
        return this.empenhoRepository.findAll(specification, (Pageable)page).map(arg_0 -> ((EmpenhoToDTO)new EmpenhoToDTO()).apply(arg_0));
    }

    private Specification<Empenho> getSpecificationEmpenho(EmpenhoParams params) {
        ProgramaticaParams programatica;
        Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, Empenho.class, (String)params.getSearch()));
        specification = specification.and(this.contabilizadoSpecification());
        if (Objects.nonNull(params.getExercicio())) {
            specification = specification.and(this.exercicioSpecification(params.getExercicio()));
        }
        if (Objects.nonNull(params.getAPagar()) && params.getAPagar().booleanValue()) {
            specification = specification.and(this.empenhosAPagarSpecification());
        }
        if (Objects.nonNull(params.getPassagens()) && params.getPassagens().booleanValue()) {
            specification = specification.and(this.passagensSpecification());
        }
        if (Objects.nonNull(params.getComprasDireta()) && params.getComprasDireta().booleanValue()) {
            if (Estado.RO.name().equalsIgnoreCase(this.entidadeService.getUf(params.getEntidadeDefault(Long.valueOf(0L))))) {
                specification = specification.and(this.dispensaInexigibilidadeSpecification());
                specification = specification.and(this.filtrarElementosAdquireBens());
            } else {
                specification = specification.and(this.dispensaLicitacaoSpecification());
                specification = specification.and(this.dispensaLicitacaoNaturezaSpecification());
            }
        }
        if (Objects.nonNull(params.getCodigoNivelDespesa())) {
            specification = specification.and(this.codigoNivelDespesaSpecification(params));
        }
        if (Objects.nonNull(params.getTipoBem()) && Objects.nonNull(params.getChapaBem())) {
            specification = specification.and(this.bemPatrimonialSpecification(params));
        }
        if (Objects.nonNull(programatica = params.getProgramatica()) && Objects.nonNull(programatica.getOrgao())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(1), programatica.getOrgao()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getUnidade())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_C, Integer.valueOf(2), programatica.getUnidade()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getFuncao())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(3), programatica.getFuncao()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getSubFuncao())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(4), programatica.getSubFuncao()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getPrograma())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(5), programatica.getPrograma()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getProjeto())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_P, Integer.valueOf(6), programatica.getProjeto()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getElemento())) {
            specification = specification.and(this.programaticaPorNivelSpecification(TIPO_C, Integer.valueOf(7), programatica.getElemento()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getDesdobramento())) {
            specification = specification.and(this.desdobramentoSpecification(programatica.getDesdobramento()));
        }
        if (Objects.nonNull(programatica) && Objects.nonNull(programatica.getSubDesdobramento())) {
            specification = specification.and(this.subDesdobramentoSpecification(programatica.getSubDesdobramento()));
        }
        if (Objects.nonNull(params.getFonteRecurso())) {
            specification = specification.and(this.fonteRecursoSpecification(params.getFonteRecurso()));
        }
        if (Objects.nonNull(params.getEsfera())) {
            specification = specification.and(this.esferaSpecification(params.getEsfera()));
        }
        return specification;
    }

    public EmpenhosListaDTO getEmpenhosTotal(EmpenhoParams params) {
        Specification spec = this.getSpecificationEmpenho(params);
        return this.empenhoRepository.geTotaisEmpenhos(params, spec);
    }

    private Specification<Empenho> contabilizadoSpecification() {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("contabilizado"), (Object)SIM);
    }

    private Specification<Empenho> empenhosAPagarSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Subquery subquery = query.subquery(BigDecimal.class);
            Root rootFicha = subquery.from(FichaEmpenho.class);
            Expression valor = cb.sum((Expression)rootFicha.get("valor"));
            Expression valorAnulacoes = cb.sum((Expression)rootFicha.get("valorAnulacoes"));
            Expression valorEstAnulacoes = cb.sum((Expression)rootFicha.get("valorEstAnulacoes"));
            Expression valorPago = cb.sum((Expression)rootFicha.get("valorPagamento"));
            Expression valorEstPagamento = cb.sum((Expression)rootFicha.get("valorEstPagamento"));
            Expression valorRetencoes = cb.sum((Expression)rootFicha.get("valorRetencoes"));
            Expression totalEmpenhado = cb.diff(valor, cb.diff(valorAnulacoes, valorEstAnulacoes));
            Expression totalPago = cb.sum(cb.diff(valorPago, valorEstPagamento), valorRetencoes);
            Expression saldoAPagar = cb.diff(totalEmpenhado, totalPago);
            subquery.select(saldoAPagar);
            subquery.where(new Predicate[]{cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get("unidadeOrcamentaria"), (Expression)root.get(ID).get("unidadeOrcamentaria")), cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get("entidade"), (Expression)root.get(ID).get("entidade")), cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get(EMPENHO), (Expression)root.get(ID).get(EMPENHO)), cb.equal((Expression)rootFicha.get(ID).get(EMPENHO).get(ID).get(EXERCICIO), (Expression)root.get(ID).get(EXERCICIO))});
            return cb.gt(subquery.as(BigDecimal.class), (Number)EPSILON);
        };
    }

    private Specification<Empenho> passagensSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, POSICAO_NATUREZA.intValue(), TAMANHO_NATUREZA.intValue());
            return cb.equal(natureza, (Object)"33");
        };
    }

    private Specification<Empenho> dispensaInexigibilidadeSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path tipoLicitacao = root.get("tipoLicitacao").get(ID);
            return tipoLicitacao.in(new Object[]{"01", "06", "09"});
        };
    }

    private Specification<Empenho> dispensaLicitacaoSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path pathTipoLicitacao = root.get("tipoLicitacao");
            return cb.equal((Expression)pathTipoLicitacao.get(ID), (Object)"00");
        };
    }

    private Specification<Empenho> dispensaLicitacaoNaturezaSpecification() {
        return (Specification & Serializable)(root, query, cb) -> {
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, POSICAO_NATUREZA.intValue(), TAMANHO_NATUREZA.intValue());
            return natureza.in(new Object[]{"30", "32", "33", "35", "36", "37", "39", "51", "52", "61", "62"});
        };
    }

    private Specification<Empenho> filtrarElementosAdquireBens() {
        return (Specification & Serializable)(root, query, cb) -> {
            NivelModeloDespesa nmd = this.nivelModeloDespesaRepository.findbyOrdemModelo(MODELODESPESA, TIPO_C, Integer.valueOf(7));
            Integer posicao = nmd.getPosicao().intValue();
            Path programatica = root.get(PROGRAMATICA);
            Expression natureza = cb.substring((Expression)programatica, posicao.intValue(), TAMANHO_ELEMENTO_RO.intValue());
            return natureza.in(new Object[]{"339030", "339032", "449052"});
        };
    }

    private Specification<Empenho> exercicioSpecification(Long exercicio) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path exercicioPath = root.get(ID).get(EXERCICIO);
            return cb.equal((Expression)exercicioPath, (Object)exercicio);
        };
    }

    private Specification<Empenho> codigoNivelDespesaSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path programatica = root.get(PROGRAMATICA);
            NivelModeloDespesa nivelModeloDespesa = this.nivelModeloDespesaRepository.findbyNivelModelo(MODELODESPESA, params.getTipoNivelDespesa(), params.getNivelLei());
            Expression nivelDespesa = cb.substring((Expression)programatica, nivelModeloDespesa.getPosicao().intValue(), nivelModeloDespesa.getTamanho().intValue());
            return cb.equal(nivelDespesa, (Object)params.getCodigoNivelDespesa());
        };
    }

    private Specification<Empenho> bemPatrimonialSpecification(EmpenhoParams params) {
        return (Specification & Serializable)(root, query, cb) -> {
            List listEmpenho = this.patrimonioMovRepository.getPatrimonioEmpenho(params);
            ArrayList predicates = Lists.newArrayList();
            Path exercicio = root.get(ID).get(EXERCICIO);
            Path empenho = root.get(ID).get(EMPENHO);
            for (PatrimonioEmpenhoDTO emp : listEmpenho) {
                Predicate exp = cb.equal((Expression)exercicio, (Object)emp.getExercicio());
                Predicate exp2 = cb.equal((Expression)empenho, (Object)emp.getEmpenho());
                predicates.add(cb.and((Expression)exp, (Expression)exp2));
            }
            return cb.or(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    private Specification<Empenho> programaticaPorNivelSpecification(String tipo, Integer nivel, String valor) {
        return (Specification & Serializable)(root, query, cb) -> {
            NivelModeloDespesa nmd = this.nivelModeloDespesaRepository.findbyOrdemModelo(MODELODESPESA, tipo, nivel);
            Integer posicao = nmd.getPosicao().intValue();
            Integer tamanho = nmd.getTamanho().intValue();
            Expression natureza = cb.substring((Expression)root.get(PROGRAMATICA), posicao.intValue(), tamanho.intValue());
            if (nivel == 7) {
                return cb.like(natureza, valor);
            }
            return cb.equal(natureza, (Object)valor);
        };
    }

    private Specification<Empenho> desdobramentoSpecification(String desdobramento) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("desdobramento"), (Object)desdobramento);
    }

    private Specification<Empenho> subDesdobramentoSpecification(String subDesdobramento) {
        return (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("subDesdobramento"), (Object)subDesdobramento);
    }

    private Specification<Empenho> fonteRecursoSpecification(Long fonteRecurso) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path fonteRecursoPath = root.get(FONTE_RECURSO);
            return cb.equal((Expression)fonteRecursoPath, (Object)fonteRecurso);
        };
    }

    private Specification<Empenho> esferaSpecification(String esfera) {
        return (Specification & Serializable)(root, query, cb) -> {
            Path esferaPath = root.get("despesa").get("esfera");
            return cb.equal((Expression)esferaPath, (Object)esfera);
        };
    }

    public EmpenhoDTO getEmpenhoDetalhe(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalhe(params);
    }

    public List<EmpenhoItensDTO> getEmpenhoDetalheItens(EmpenhoParams params) {
        List itens = this.empenhoRepository.getEmpenhoDetalheItens(params);
        itens.forEach(item -> item.setItensPerc(this.nadItemPercentualService.getEmpenhoDetalheItensPerc(item)));
        return itens;
    }

    public List<EmpenhoAnulacaoDTO> getEmpenhoDetalheAnulacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheAnulacao(params);
    }

    public List<EmpenhoLiquidacaoDTO> getEmpenhoDetalheLiquidacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheLiquidacao(params);
    }

    public List<EmpenhoPagamentoDTO> getEmpenhoDetalhePagamento(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalhePagamento(params);
    }

    public List<EmpenhoRetencaoDTO> getEmpenhoDetalheRetencao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheRetencao(params);
    }

    public List<EmpenhoDocumentoDTO> getEmpenhoDetalheDocumentos(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheDocumentos(params);
    }

    public List<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheMovimentacao(params);
    }

    public List<EmpenhoAnexosDTO> getEmpenhoDetalheAnexos(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheAnexos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public Page<ComprasDiretaDTO> getComprasDiretaItensEmpenho(Pageable pageable, EmpenhoParams params) {
        Specification specification = this.getSpecificationEmpenho(params);
        PageRequest pageRequest = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id.exercicio", "id.empenho"});
        Page page = this.empenhoRepository.findAll(specification, (Pageable)pageRequest);
        List itemDTO = page.getContent().stream().flatMap(e -> e.getItems().stream().map(arg_0 -> ((ComprasDiretaToDTO)new ComprasDiretaToDTO()).apply(arg_0))).collect(Collectors.toList());
        return new PageImpl(itemDTO, pageable, page.getTotalElements());
    }

    public EmpenhoItensDTO getEmpenhoDetalheItem(EmpenhoParams params) {
        List itens = this.empenhoRepository.getEmpenhoDetalheItens(params);
        EmpenhoItensDTO item = itens.stream().findFirst().orElse(new EmpenhoItensDTO());
        item.setItensPerc(this.nadItemPercentualService.getEmpenhoDetalheItensPerc(item));
        return item;
    }

    public List<EmpenhoEmLiquidacaoDTO> getEmpenhoDetalheEmLiquidacao(EmpenhoParams params) {
        return this.empenhoRepository.getEmpenhoDetalheEmLiquidacao(params);
    }
}

