/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource.params;

import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class CargoParams
implements AiseParams {
    private Long entidade;
    private Long exercicio;
    private Long cargo;
    private String quadro;
    private String grupo;
    private String nivel;
    private String descricao;

    public Optional<Long> getCargo() {
        return Optional.ofNullable(this.cargo);
    }

    public Optional<String> getQuadro() {
        return Optional.ofNullable(this.quadro);
    }

    public Optional<String> getGrupo() {
        return Optional.ofNullable(this.grupo);
    }

    public Optional<String> getNivel() {
        return Optional.ofNullable(this.nivel);
    }

    public String getDescricao() {
        if (Objects.isNull(this.descricao)) {
            this.descricao = "";
        }
        return this.descricao;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setCargo(Long cargo) {
        this.cargo = cargo;
    }

    public void setQuadro(String quadro) {
        this.quadro = quadro;
    }

    public void setGrupo(String grupo) {
        this.grupo = grupo;
    }

    public void setNivel(String nivel) {
        this.nivel = nivel;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        if (Objects.nonNull(this.cargo)) {
            params.addValue("cargo", (Object)this.cargo, 2);
        }
        if (Objects.nonNull(this.quadro)) {
            params.addValue("quadro", (Object)this.quadro, 12);
        }
        if (Objects.nonNull(this.grupo)) {
            params.addValue("grupo", (Object)this.grupo, 12);
        }
        if (Objects.nonNull(this.nivel)) {
            params.addValue("nivel", (Object)this.nivel, 12);
        }
        return params;
    }

    public void setEntidadeAise(Long entidadeAise) {
        this.setEntidade(entidadeAise);
    }

    public Long getEntidadeAise() {
        return this.entidade;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public static CargoParamsBuilder builder() {
        return new CargoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "CargoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.exercicio + ", cargo=" + this.getCargo() + ", quadro=" + this.getQuadro() + ", grupo=" + this.getGrupo() + ", nivel=" + this.getNivel() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public CargoParams() {
    }

    @Generated
    public CargoParams(Long entidade, Long exercicio, Long cargo, String quadro, String grupo, String nivel, String descricao) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.cargo = cargo;
        this.quadro = quadro;
        this.grupo = grupo;
        this.nivel = nivel;
        this.descricao = descricao;
    }
}

