SELECT S.ENTIDADE,
       S.EXERCICIO,
       S.SUBVENCAO,
       S.ANOSUBVENCAO,
       S.SEQUENCIA,
       S.DATA,
       T.DESCRICAO AS TIPO,
       S.DESCRICAO,
       S.DATAPRAZO,
       CASE WHEN A.NOMEARQUIVO IS NULL THEN ARQ.NOMEARQUIVO ELSE A.NOMEARQUIVO END AS NOMEARQUIVO,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       A.IDARQUIVO, 
       A.DATA AS DATAARQUIVO
  FROM SUBVENCAOSITUACAO S
  JOIN TIPOSITUACAOSUBVENCAO T
    ON T.ID = S.IDTIPO
  LEFT JOIN SUBVENCAOARQUIVO SA
    ON SA.ENTIDADE = S.ENTIDADE
   AND SA.EXERCICIO = S.EXERCICIO
   AND SA.SUBVENCAO = S.SUBVENCAO
   AND SA.ANOSUBVENCAO = S.ANOSUBVENCAO
   AND SA.NUMEROARQUIVO = S.SEQUENCIA
   AND SA.IDTIPO = 2
  LEFT JOIN ARQUIVO A
    ON A.ID = SA.IDARQUIVO
  LEFT JOIN ARQUIVO ARQ 
    ON ARQ.ID = SA.IDARQUIVO
  LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ 
    ON ELOARQ.ID = ARQ.IDARQUIVO 
  LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC 
    ON AC.ID = ARQ.IDARQUIVO
 WHERE S.ENTIDADE  = :entidade
   AND S.EXERCICIO = :exercicio
   AND S.SUBVENCAO = :subvencao
   AND S.ANOSUBVENCAO = :anoSubvencao
 ORDER BY S.SEQUENCIA