SELECT S.ENTIDADE, 
       S.EXERCICIO,
       S.SUBVENCAO,
       S.ANOSUBVENCAO,
       S.NUMEROADITIVO,
       S.ANOADITIVO,
       T.DESCRICAO AS TIPO,
       S.NUMEROTERMO,
       S.DATATERMO,
       S.DATAFIMVIGENCIA,
       S.NUMERODIARIOOFICIAL,
       S.ANODIARIOOFICIAL,
       S.DATAPUBLICACAODIARIO,
       S.FORNECEDORDIARIO,
       F.NOME,
       F.FANTASIA,
       S.VALOR,
       S.VALORCONTRAPARTIDA,
       S.DESCRICAO,
       CASE WHEN A.NOMEARQUIVO IS NULL THEN ARQ.NOMEARQUIVO ELSE A.NOMEARQUIVO END AS NOMEARQUIVO,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       A.IDARQUIVO,
       A.DATA AS DATAARQUIVO
  FROM SUBVENCAOADITIVO S
  JOIN TIPOADITIVOSUBVENCAO T
    ON T.ID = S.IDTIPO
  LEFT JOIN FORNECEDOR F
    ON F.FORNECEDOR = S.FORNECEDORDIARIO
  LEFT JOIN SUBVENCAOARQUIVO SA
    ON SA.ENTIDADE = S.ENTIDADE
   AND SA.EXERCICIO = S.EXERCICIO
   AND SA.SUBVENCAO = S.SUBVENCAO
   AND SA.ANOSUBVENCAO = S.ANOSUBVENCAO
   AND SA.NUMEROARQUIVO = S.NUMEROADITIVO
   AND SA.ANOADITIVO = S.ANOADITIVO
   AND SA.IDTIPO = 3
  LEFT JOIN ARQUIVO A
    ON A.ID = SA.IDARQUIVO
  LEFT JOIN ARQUIVO ARQ 
    ON ARQ.ID = SA.IDARQUIVO
  LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ 
    ON ELOARQ.ID = ARQ.IDARQUIVO 
  LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC 
    ON AC.ID = ARQ.IDARQUIVO
 WHERE S.ENTIDADE = :entidade
   AND S.EXERCICIO = :exercicio
   AND S.SUBVENCAO = :subvencao
   AND S.ANOSUBVENCAO = :anoSubvencao
 ORDER BY S.ANOADITIVO, S.NUMEROADITIVO