SELECT A.ENTIDADE,
       A.EXERCICIO,
       A.CONTRATO,
       A.NUMEROCONTRATO,
       B.NOME,
       A.INICIOVIGENCIA,
       A.TERMINOVIGENCIA,
       A.VALORCONTRATADO,
       A.VALORADITIVO,
       A.TIPOATO,
       C.UNIDADEFEDERACAO AS UF,
       A.TIPOCONTRATO,
       TIPOLIC.DESCRICAO AS DESCRICAOTIPOLICITACAO,
       L.NUMEROLICITACAO,
       A.OBJETO,
       A.EXERCICIOLICITACAO,
  CASE A.TIPOATO
  WHEN 1 THEN 'Contrato'
  WHEN 2 THEN 'Registro de Preço' END AS DESCRICAOTIPOATO,
  CASE WHEN (SELECT COUNT(*)
               FROM CLCONTRATOATOCONTRATUAL B
              WHERE A.ENTIDADE = B.ENTIDADE
                AND A.EXERCICIO = B.EXERCICIOCONTRATO
                AND A.CONTRATO = B.CONTRATO
                AND B.IDTIPOADITIVO = 5
                AND B.IDTIPOOPERACAO = 10) >= 1
       THEN 'Rescindido'
       WHEN A.TERMINOVIGENCIA IS NOT NULL AND A.TERMINOVIGENCIA < :dataAtual
        AND (SELECT coalesce(max(b.datatermino), :dataZero) FROM CLCONTRATOATOCONTRATUAL B
              WHERE A.ENTIDADE = B.ENTIDADE
                AND A.EXERCICIO = B.EXERCICIOCONTRATO
                AND A.CONTRATO = B.CONTRATO
                AND B.DATATERMINO IS NOT NULL) < :dataAtual
       THEN 'Encerrado'
       ELSE 'Vigente' END AS CANCELADO
  FROM CLCONTRATO A
  LEFT OUTER JOIN VW_LICITACAOPORTAL_LISTA L
    ON A.ENTIDADE = L.ENTIDADE
   AND A.EXERCICIOLICITACAO = L.EXERCICIO
   AND A.TIPOLICITACAO = L.TIPOLICITACAO
   AND A.LICITACAO = L.LICITACAO
  LEFT OUTER JOIN CLTIPOLICITACAO TIPOLIC
    ON L.TIPOLICITACAO = TIPOLIC.TIPOLICITACAO
  LEFT OUTER JOIN PESSOA B
    ON A.PESSOA = B.PESSOA
  LEFT OUTER JOIN ENTIDADE C
    ON C.ENTIDADE = A.ENTIDADE
