SELECT RES.ENTIDADE,
       PES.NOME NOME,
       RES.ESTAGIARIO CODIGO,
       LOT.DESCRICAO LOTACAO,
       RLT.DESCRICAO LOCALTRABALHO,
       RHT.ENTRADA HORARIOENTRADA,
       RHT.SAIDAINTERVALO HORARIOSAIDAINTERVALO,
       RHT.ENTRADAINTERVALO HORARIOENTRADAINTERVALO,
       RHT.SAIDA HORARIOSAIDA,
       RCG.DESCRICAO CARGO,
       RCG.HORASSEMANAIS,
       RFX.FAIXA FAIXA,
       (SELECT MIN (DATAINICIO)
          FROM RHESTAGIARIOPERIODO REPX
         WHERE RES.ENTIDADE = REPX.ENTIDADE
           AND RES.ESTAGIARIO = REPX.ESTAGIARIO) INICIOCONTRATO,
       COALESCE (RES.DATARESCISAO, (SELECT MAX (DATAFIM)
                                      FROM RHESTAGIARIOPERIODO REPX
                                     WHERE RES.ENTIDADE = REPX.ENTIDADE
                                       AND RES.ESTAGIARIO = REPX.ESTAGIARIO
                                       AND EXTRACT(YEAR FROM DATAFIM) >= :exercicio)) TERMINOCONTRATO
  FROM RHESTAGIARIO RES
  JOIN PESSOA PES
    ON RES.PESSOA = PES.PESSOA
  LEFT JOIN RHLOTACAO LOT
    ON RES.ENTIDADE = LOT.ENTIDADE
   AND RES.MODELOLOTACAO = LOT.MODELOLOTACAO
   AND RES.NIVELLOTACAO = LOT.NIVELLOTACAO
   AND RES.LOTACAO = LOT.LOTACAO
  LEFT JOIN RHLOCALDETRABALHO RLT
    ON RES.LOCALDETRABALHO = RLT.LOCALDETRABALHO
  LEFT JOIN RHHORARIOTRABALHO RHT
    ON RES.ENTIDADE = RHT.ENTIDADE
   AND RES.HORARIOTRABALHO = RHT.HORARIOTRABALHO
  LEFT JOIN RHCARGO RCG
    ON RES.ENTIDADE = RCG.ENTIDADE
   AND RES.CARGO = RCG.CARGO
  LEFT JOIN RHGRUPOOCUPACIONALFAIXA RFX
    ON RES.ENTIDADE = RFX.ENTIDADE
   AND RES.QUADROSALARIAL = RFX.QUADROSALARIAL
   AND RES.GRUPOOCUPACIONAL = RFX.GRUPOOCUPACIONAL
   AND RES.NIVEL = RFX.NIVEL
   AND RES.FAIXA = RFX.FAIXA
 WHERE RES.ENTIDADE = :entidade
   AND (RES.DATARESCISAO IS NULL OR EXTRACT(YEAR FROM RES.DATARESCISAO) >= :exercicio)
   AND (SELECT EXTRACT(YEAR FROM MIN(DATAINICIO))
          FROM RHESTAGIARIOPERIODO REPX
         WHERE RES.ENTIDADE = REPX.ENTIDADE
           AND RES.ESTAGIARIO = REPX.ESTAGIARIO) <= :exercicio
