/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.config.PessoaClientUnico;
import br.com.elotech.portaltransparencia.exception.ParametroMalConfiguradoException;
import br.com.elotech.portaltransparencia.protocportal.domain.EnderecoPessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.EnderecoPessoaPK;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.portaltransparencia.protocportal.mapper.PessoaDtoToPessoa;
import br.com.elotech.portaltransparencia.protocportal.mapper.PessoaToDto;
import br.com.elotech.portaltransparencia.protocportal.repository.PessoaRepository;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import br.com.elotech.portaltransparencia.protocportal.service.PessoaService;
import br.com.elotech.unico.client.dto.PessoaDTO;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PessoaServiceImpl
implements PessoaService {
    private final PessoaRepository pessoaRepository;
    private final ParametroService parametroService;
    private final DBConfigProperties dbConfigProperties;
    private final PessoaClientUnico pessoaClient;

    public PessoaServiceImpl(PessoaRepository pessoaRepository, ParametroService parametroService, PessoaClientUnico pessoaClient, DBConfigProperties dbConfigProperties) {
        this.pessoaRepository = pessoaRepository;
        this.parametroService = parametroService;
        this.pessoaClient = pessoaClient;
        this.dbConfigProperties = dbConfigProperties;
    }

    private Pessoa addPessoaEndereco(Pessoa pessoa, EnderecoPessoa endereco) {
        EnderecoPessoa enderecoPessoa = this.criarEndereco(pessoa, endereco);
        pessoa.addEnderecos(new EnderecoPessoa[]{enderecoPessoa});
        return pessoa;
    }

    private EnderecoPessoa criarEndereco(Pessoa pessoa, EnderecoPessoa endereco) {
        if (endereco.getId() == null) {
            EnderecoPessoaPK pk = new EnderecoPessoaPK();
            pk.setCodigo(Long.valueOf(1L));
            pk.setPessoa(pessoa);
            pk.getPessoa().setSequenciaEndereco(Long.valueOf(1L));
            endereco.setId(pk);
        }
        return endereco;
    }

    private Pessoa savePessoa(Pessoa pessoa) {
        if (this.integradoComUnico()) {
            PessoaDTO saved = this.pessoaClient.savePessoa(new PessoaToDto().convert(pessoa));
            return new PessoaDtoToPessoa().apply(saved);
        }
        if (!NumberUtils.isBiggerThanZero((Number)pessoa.getId()).booleanValue()) {
            pessoa.setId(this.pessoaRepository.nextId());
            pessoa.setTipoPessoa(TipoPessoa.FISICA);
        }
        return (Pessoa)this.pessoaRepository.save((Object)pessoa);
    }

    public Pessoa fetchPessoa(Long entidade, Long exercicio, Pessoa pessoa, EnderecoPessoa endereco) {
        if (pessoa == null) {
            String parametroPessoaAnonimo = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(88L));
            if (StringUtils.isNotBlank((CharSequence)parametroPessoaAnonimo)) {
                return this.pessoaRepository.findTopByIdOrderByIdDesc(Long.valueOf(Long.parseLong(parametroPessoaAnonimo)));
            }
            throw new ParametroMalConfiguradoException(String.format("O valor do par\u00e2metro %d n\u00e3o est\u00e1 configurado corretamente.", 88L));
        }
        Optional pessoaCadastrada = this.findPessoaByCnpjCpf(pessoa.getCnpjCpf());
        if (pessoaCadastrada.isPresent()) {
            if (this.integradoComUnico()) {
                this.pessoaClient.ativaProtocolo(((Pessoa)pessoaCadastrada.get()).getIdUnico());
                return this.pessoaRepository.findTopByCnpjCpfOrderByIdDesc(((Pessoa)pessoaCadastrada.get()).getCnpjCpf());
            }
            return (Pessoa)pessoaCadastrada.get();
        }
        return this.savePessoa(this.addPessoaEndereco(pessoa, endereco));
    }

    public Optional<Pessoa> findPessoaByCnpjCpf(String cnpjCpf) {
        if (this.integradoComUnico()) {
            String search = String.format("cnpjCpf=='%s'", cnpjCpf);
            return this.pessoaClient.findFirstPessoaByRSQL(search);
        }
        return Optional.ofNullable(this.pessoaRepository.findTopByCnpjCpfOrderByIdDesc(cnpjCpf));
    }

    private boolean integradoComUnico() {
        return this.dbConfigProperties.getUnico().getHost() != null && this.dbConfigProperties.getUnico().getUser() != null && !this.dbConfigProperties.getUnico().getHost().isEmpty() && !this.dbConfigProperties.getUnico().getUser().isEmpty();
    }
}

