/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeProtocoloService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoEsicParams;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.params.SalvaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.service.ProcessoService;
import java.util.Calendar;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.MailException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/processos"})
public class ProcessoResource {
    private final Logger log = LoggerFactory.getLogger(ProcessoResource.class);
    private final ProcessoService processoService;
    private final EntidadeProtocoloService entidadeProtocoloService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeContabilidadeRepository;

    public ProcessoResource(ProcessoService processoService, EntidadeProtocoloService entidadeProtocoloService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeContabilidadeRepository) {
        this.processoService = processoService;
        this.entidadeProtocoloService = entidadeProtocoloService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeContabilidadeRepository = entidadeContabilidadeRepository;
    }

    @GetMapping
    public ResponseEntity<ProcessoDTO> findProcesso(@RequestHeader(value="entidade") Long entidade, @Valid ConsultaProcessoParams params) {
        params.setEntidade(this.entidadeProtocoloService.getCodigoEntidadeProtocolo(entidade));
        ProcessoDTO processo = this.processoService.consultaProcesso(params);
        if (Objects.isNull(processo)) {
            return ResponseEntity.ok((Object)new ProcessoDTO());
        }
        return ResponseEntity.ok((Object)processo);
    }

    @PostMapping
    public ResponseEntity<ProcessoDTO> saveProcesso(@RequestHeader(value="entidade") Long entidade, @Valid @RequestBody SalvaProcessoParams params, UriComponentsBuilder builder, HttpServletRequest request) {
        params.setEntidade(entidade);
        params.setEntidadeProtocolo(this.entidadeProtocoloService.getCodigoEntidadeProtocolo(entidade));
        params.setExercicio(Long.valueOf(Calendar.getInstance().get(1)));
        ProcessoDTO processo = this.processoService.salvaProcesso(params);
        processo.setUrl(params.getUrl());
        try {
            if (((Boolean)this.processoService.enviaeSicEmail(processo).get()).booleanValue()) {
                this.log.info("Email enviado para o solicitante com sucesso");
            }
        }
        catch (InterruptedException | ExecutionException | MailException e) {
            this.log.error("Falha no envio de email para o solicitante", e);
        }
        try {
            if (((Boolean)this.processoService.enviaContatoEmail(processo).get()).booleanValue()) {
                this.log.info("Email enviado para a entidade com sucesso");
            }
        }
        catch (InterruptedException | ExecutionException | MailException e) {
            this.log.error("Falha no envio de email para a Entidade", e);
        }
        return ResponseEntity.ok((Object)processo);
    }

    @GetMapping(value={"/esic"})
    public ResponseEntity<Page<ProcessoDTO>> findProcessoByTipo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, ConsultaProcessoEsicParams params, Pageable pageable) {
        this.setExercicioEntidade(entidade, exercicio, params);
        return ResponseEntity.ok((Object)this.processoService.findProcessoByTipo(params, pageable));
    }

    private void setExercicioEntidade(Long entidade, Long exercicio, ConsultaProcessoEsicParams params) {
        params.setEntidade(this.entidadeProtocoloService.getCodigoEntidadeProtocolo(entidade));
        params.setExercicio(exercicio);
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportReport(HttpServletRequest request, HttpServletResponse response, ConsultaProcessoEsicParams params, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        this.setExercicioEntidade(params.getEntidade(), params.getExercicio(), params);
        Page listESic = this.processoService.findProcessoByTipo(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeContabilidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Consulta SIC");
        reportParam.setClazzDTO(ProcessoDTO.class);
        reportParam.setHeaderFields("Data,Processo,Solicita\u00e7\u00e3o,Situa\u00e7\u00e3o,Motivo/Assunto,Tipo de Consulta");
        reportParam.setFields("data,processo,digitacao,situacao,assunto,usuario");
        float[] fieldsPerc = new float[]{1.0f, 1.0f, 2.5f, 1.0f, 2.5f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 15, 100, 50, 100, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(listESic.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

