/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.repository.impl;

import br.com.elotech.core.domain.KeyField;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.jpa.support.DBNamingStrategy;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.config.DatasourceWrapperProtocolo;
import br.com.elotech.portaltransparencia.protocportal.domain.Processo;
import br.com.elotech.portaltransparencia.protocportal.domain.ProcessoPK;
import br.com.elotech.portaltransparencia.protocportal.domain.TipoProcesso;
import br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoEsicParams;
import br.com.elotech.portaltransparencia.protocportal.repository.ProcessoRepositoryCustom;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ProcessoRepositoryImpl
implements ProcessoRepositoryCustom {
    private static final String GEN_PROCESSO = "GEN_PROCESSO";
    private static final String GEN_NUMEROPROCESSO = "GEN_NUMEROPROCESSO";
    private static final String UNDERSCORE = "_";
    private static final String SIM = "S";
    private static final String PROCESSOSESIC = "db/sql/protoc/ProcessoEsic.sql";
    private static final String PROCESSOESIC_COUNT = "db/sql/protoc/ProcessoEsicCount.sql";
    private final EntityManagerFactory emf;
    private final DBNamingStrategy dbNamingStrategy;
    private final ParametroService parametroService;
    private final DatasourceWrapper datasourceWrapper;
    private List<KeyField> keyFields;

    public ProcessoRepositoryImpl(ParametroService parametroService, DatasourceWrapperProtocolo datasourceWrapper, @Qualifier(value="entityManagerProtocolo") EntityManagerFactory emf, DBNamingStrategy dbNamingStrategy) {
        this.parametroService = parametroService;
        this.datasourceWrapper = datasourceWrapper;
        this.emf = emf;
        this.dbNamingStrategy = dbNamingStrategy;
    }

    public Long getNextSequence(Processo processo) {
        return EloSequenceGenerator.getNext((JdbcOperations)this.datasourceWrapper.getJdbcTemplate().getJdbcOperations(), (Field)ProcessoPK.class.getDeclaredField("numero"), Processo.class, (EntityManagerFactory)this.emf, (DBNamingStrategy)this.dbNamingStrategy, (String)this.nomeSequence(processo.getId().getEntidade().getId(), processo.getId().getTipo()), (List)this.keyFields, (Object)processo);
    }

    private String nomeSequence(Long entidade, TipoProcesso tipo) {
        StringBuilder nomeSequence = new StringBuilder();
        nomeSequence.append(GEN_NUMEROPROCESSO);
        String porEntidade = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(18L));
        String porDia = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(81L));
        this.keyFields = new ArrayList();
        if (SIM.equals(porEntidade)) {
            nomeSequence.append(UNDERSCORE);
            nomeSequence.append(entidade);
            this.keyFields.add(new KeyField("id.entidade.id", "entidade"));
        }
        if (SIM.equals(porDia)) {
            LocalDate date = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMyyyy");
            nomeSequence.append(UNDERSCORE);
            nomeSequence.append(date.format(formatter));
            String result = Pattern.compile(GEN_NUMEROPROCESSO).matcher(nomeSequence).replaceAll(GEN_PROCESSO);
            nomeSequence = new StringBuilder(result);
            this.keyFields.add(new KeyField("dataOrigem", "dataOrigem"));
        } else {
            nomeSequence.append(UNDERSCORE);
            nomeSequence.append(LocalDate.now().getYear());
            this.keyFields.add(new KeyField("id.ano", "ano"));
        }
        nomeSequence.append(UNDERSCORE);
        nomeSequence.append(tipo.getId());
        this.keyFields.add(new KeyField("id.tipo.id", "tipo"));
        return nomeSequence.toString();
    }

    public Page<ProcessoDTO> findProcessoByTipo(ConsultaProcessoEsicParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOSESIC);
        String sqlCount = FileUtils.readResourceAsString((String)PROCESSOESIC_COUNT);
        StringBuilder query = this.setSqlParams(params, sql);
        StringBuilder queryCount = this.setSqlParams(params, sqlCount);
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY P.DATAPROCESSO DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List processos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(processos, pageable, total.longValue());
    }

    private StringBuilder setSqlParams(ConsultaProcessoEsicParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        if (params.getUsuario().isPresent()) {
            query.append(" AND P.USUARIOREG = :usuario");
        } else {
            query.append(" AND P.USUARIOREG <> 'e-SIC'");
        }
        params.getDataInicial().ifPresent(item -> query.append(" AND P.DATAPROCESSO >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append(" AND P.DATAPROCESSO <= :dataFinal "));
        return query;
    }
}

