/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.mapper;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.Contato;
import br.com.elotech.portaltransparencia.protocportal.domain.EnderecoPessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.unico.client.dto.PessoaContatoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.PessoaEnderecoDTO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PessoaDtoToPessoa
implements Function<PessoaDTO, Pessoa> {
    @Override
    public Pessoa apply(PessoaDTO dto) {
        Pessoa pessoa = new Pessoa();
        pessoa.setId(dto.getCodigoProtocolo());
        pessoa.setIdUnico(dto.getId());
        pessoa.setNome(dto.getNome());
        pessoa.setCnpjCpf(dto.getCnpjCpf());
        pessoa.setTipoPessoa(this.toTipoPessoa(dto));
        pessoa.setContato(this.toContato(dto.getContatos()));
        pessoa.addEnderecos(this.toEnderecos(dto.getEnderecos()));
        if (dto.getRg() != null) {
            pessoa.setRg(dto.getRg().getNumero());
        }
        return pessoa;
    }

    private EnderecoPessoa[] toEnderecos(List<PessoaEnderecoDTO> enderecos) {
        return (EnderecoPessoa[])enderecos.stream().map(e -> {
            EnderecoPessoa enderecoPessoa = new EnderecoPessoa();
            enderecoPessoa.setNumero(e.getNumero());
            enderecoPessoa.setComplemento(e.getComplemento());
            enderecoPessoa.setCep(this.toCep(e));
            return enderecoPessoa;
        }).toArray(EnderecoPessoa[]::new);
    }

    private String toCep(PessoaEnderecoDTO dto) {
        if (Objects.nonNull(dto.getCep())) {
            return dto.getCep().toString();
        }
        return null;
    }

    private TipoPessoa toTipoPessoa(PessoaDTO dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getTipoPessoa())) {
            return TipoPessoa.fromString((String)dto.getTipoPessoa());
        }
        return null;
    }

    private Contato toContato(List<PessoaContatoDTO> list) {
        Optional optionalDto = list.stream().findFirst();
        return optionalDto.map(dto -> {
            Contato contato = new Contato();
            contato.setCelular(dto.getContato().getTelefoneCelular());
            contato.setTelefone(dto.getContato().getTelefoneResidencial());
            contato.setEmail(dto.getContato().getEmail());
            return contato;
        }).orElse(null);
    }
}

