/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBem;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioDetalheDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PatrimonioParams;
import br.com.elotech.portaltransparencia.contabportal.service.PatrimonioAlienacaoService;
import br.com.elotech.portaltransparencia.contabportal.service.PatrimonioBemService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/patrimonios"})
public class PatrimonioBemResource {
    private final PatrimonioBemService patrimonioBemService;
    private final PatrimonioAlienacaoService patrimonioAlienacaoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public PatrimonioBemResource(PatrimonioBemService patrimonioBemService, PatrimonioAlienacaoService patrimonioAlienacaoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.patrimonioBemService = patrimonioBemService;
        this.patrimonioAlienacaoService = patrimonioAlienacaoService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<PatrimonioBemDTO>> findPatrimonioBem(Pageable pageable, PatrimonioParams params) {
        return ResponseEntity.ok((Object)this.patrimonioBemService.getListPatrimonioBem(pageable, params));
    }

    @GetMapping(params={"entidade", "bem", "chapa", "tipo"})
    public ResponseEntity<PatrimonioBem> findByBem(PatrimonioParams params) {
        PatrimonioBem patrimonioBem = this.patrimonioBemService.findByBem(params);
        return ResponseEntity.ok((Object)patrimonioBem);
    }

    @GetMapping(value={"/detalhe"}, params={"entidade", "bem", "chapa", "tipo"})
    public ResponseEntity<List<PatrimonioDetalheDTO>> findByLocalAtualEntidadeAndModelo(@RequestHeader(value="exercicio") Long exercicio, PatrimonioParams params) {
        params.setExercicio(exercicio);
        List list = this.patrimonioBemService.findPatrimonioDetalhe(params);
        return ResponseEntity.ok((Object)list);
    }

    @GetMapping(value={"/alienacoes"})
    public ResponseEntity<List<PatrimonioAlienacao>> findPatrimonioAlienacao() {
        ArrayList list = Lists.newArrayList((Iterable)this.patrimonioAlienacaoService.findAll());
        return ResponseEntity.ok((Object)list);
    }

    @GetMapping(value={"/alienacoes/com-bens"})
    public ResponseEntity<List<PatrimonioAlienacao>> findPatrimonioAlienacaoComBensVinculados() {
        ArrayList list = Lists.newArrayList((Iterable)this.patrimonioAlienacaoService.findAllComBens());
        return ResponseEntity.ok((Object)list);
    }

    @GetMapping(value={"/report"})
    public ModelAndView patrimonioBemExport(HttpServletRequest request, HttpServletResponse response, Pageable pageable, PatrimonioParams params, @RequestParam(value="entidade", required=true) Long entidade) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page listaPatrimonios = this.patrimonioBemService.getListPatrimonioBem((Pageable)page, params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)entidade);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem de Bens");
        reportParam.setClazzDTO(PatrimonioBemDTO.class);
        reportParam.setHeaderFields("Tombamento,Tipo,Descri\u00e7\u00e3o,Aquisi\u00e7\u00e3o,Tipo Incorpora\u00e7\u00e3o,Valor Atual,Valor Aquisi\u00e7\u00e3o,Situa\u00e7\u00e3o");
        reportParam.setFields("chapa,displayTipoPatrimonio,descricao,dataAquisicao,displayTipoIncorporacao,valorAtual,valorAquisicao,baixado");
        float[] fieldsPerc = new float[]{1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 20, 300, 20, 50, 20, 20, 30};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(listaPatrimonios.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

