/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.AlvaraDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.AlvaraRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AlvaraParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AlvaraRepositoryImpl
implements AlvaraRepository {
    private static final String ALVARAS = "db/sql/aise/alvaras.sql";
    private static final String ALVARAS_ARQUIVOS = "db/sql/aise/alvaras-arquivos.sql";
    private static final String ALVARA_ARQUIVO = "db/sql/aise/alvaras-arquivo.sql";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AlvaraRepositoryImpl(@Qualifier(value="wrapperAise") DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<AlvaraDTO> findAlvaras(AlvaraParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)ALVARAS));
        if (Objects.nonNull(params.getNome())) {
            sql.append(" AND P.NOME LIKE '%" + params.getNome() + "%'");
        }
        if (Objects.nonNull(params.getNomeFantasia())) {
            sql.append(" AND P.NOMEFANTASIA LIKE '%" + params.getNomeFantasia() + "%'");
        }
        if (Objects.nonNull(params.getCnpjCpf())) {
            sql.append(" AND P.CNPJ_CPF = '" + params.getCnpjCpf() + "'");
        }
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(SqlUtils.createSQLCount((String)sql.toString()), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY P.NOME");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        return new PageImpl(this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AlvaraDTO.class)), pageable, total.longValue());
    }

    public AlvaraDTO findAlvara(AlvaraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)ALVARAS));
        sql.append(" AND P.PESSOA = :pessoa ");
        return (AlvaraDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AlvaraDTO.class));
    }

    public List<AlvaraDTO> findAlvaraArquivos(AlvaraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String sql = FileUtils.readResourceAsString((String)ALVARAS_ARQUIVOS);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AlvaraDTO.class));
    }

    public ArquivoDTO getArquivo(Long idArquivo) {
        String sql = FileUtils.readResourceAsString((String)ALVARA_ARQUIVO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("id", (Object)idArquivo, 2);
        return (ArquivoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoDTO.class));
    }
}

