/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.portaltransparencia.admportal.domain.Glossario;
import br.com.elotech.portaltransparencia.admportal.domain.GlossarioPK;
import br.com.elotech.portaltransparencia.admportal.domain.dto.GlossarioDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.GlossarioConverter;
import br.com.elotech.portaltransparencia.admportal.resource.params.GlossarioParams;
import br.com.elotech.portaltransparencia.admportal.service.GlossarioService;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/glossario", "/admin/glossarios"})
public class GlossarioResource {
    private final GlossarioService glossarioService;

    @Autowired
    public GlossarioResource(GlossarioService glossarioService) {
        this.glossarioService = glossarioService;
    }

    @GetMapping(value={"/entidade"})
    public ResponseEntity<List<Glossario>> findListByEntidade(@RequestHeader(value="entidade") Long entidade) {
        return ResponseEntity.ok((Object)this.glossarioService.findGlossario(entidade));
    }

    @GetMapping(value={"/entidade/{idEntidade}"})
    public ResponseEntity<Page<GlossarioDTO>> findPageByIdEntidade(@PathVariable(value="idEntidade") Long idEntidade, Pageable pageable) {
        Page glossarioPage = this.glossarioService.findByIdEntidade(idEntidade, pageable);
        return ResponseEntity.ok((Object)glossarioPage.map(GlossarioConverter::toDTO));
    }

    @GetMapping(params={"id", "entidade"})
    public ResponseEntity<GlossarioDTO> findOne(GlossarioParams params) {
        Glossario glossario = (Glossario)this.glossarioService.findOne((Serializable)GlossarioPK.of((Long)params.getEntidade(), (Long)params.getId()));
        if (Objects.isNull(glossario)) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)GlossarioConverter.toDTO((Glossario)glossario));
    }

    @PostMapping
    public ResponseEntity<GlossarioDTO> save(@RequestBody GlossarioDTO glossarioDTO) throws URISyntaxException {
        Glossario glossario = GlossarioConverter.toEntity((GlossarioDTO)glossarioDTO);
        Glossario saved = this.glossarioService.save(glossario);
        return ResponseEntity.created((URI)new URI("")).body((Object)GlossarioConverter.toDTO((Glossario)saved));
    }

    @PutMapping(params={"id", "entidade"})
    public ResponseEntity<GlossarioDTO> update(@RequestBody GlossarioDTO glossarioDTO, GlossarioParams params) {
        Glossario glossario = (Glossario)this.glossarioService.findOne((Serializable)GlossarioPK.of((Long)params.getEntidade(), (Long)params.getId()));
        if (Objects.isNull(glossario)) {
            throw RestException.notFound();
        }
        GlossarioConverter.insertDTOtoEntity((GlossarioDTO)glossarioDTO, (Glossario)glossario);
        return ResponseEntity.ok((Object)GlossarioConverter.toDTO((Glossario)this.glossarioService.save(glossario)));
    }

    @DeleteMapping(params={"id", "entidade"})
    public ResponseEntity<Void> remove(GlossarioParams params) {
        Glossario glossario = (Glossario)this.glossarioService.findOne((Serializable)GlossarioPK.of((Long)params.getEntidade(), (Long)params.getId()));
        if (Objects.isNull(glossario)) {
            return ResponseEntity.notFound().build();
        }
        this.glossarioService.delete(glossario);
        return ResponseEntity.ok().build();
    }
}

