SELECT S.ENTIDADE,
       S.EXERCICIO,
       S.SUBVENCAO,
       S.ANOSUBVENCAO,
       E.NOME AS ORGAO,
       S.TERMO,
       S.LEIAUTORIZATORIA,
       TS.ID ||' - '|| TS.DESCRICAO AS TIPOSUBVENCAO,
       S.ENTIDADEBENEFICIARIA,
       S.NOMEBENEFICIARIO,
       F.CNPJ,
       S.TIPOENTIDADE,
       S.OBJETO,
       S.UNIDADEMEDIDA,
       S.PERIODICIDADEPRESTACAO,
       S.DATATLIMITE,
       S.DATAINICIOCONVENIO,
       S.DATAVENCIMENTOCONVENIO,
       S.ARTIGOLOA,
       S.NRQTDPREVISTA,
       COALESCE(S.VALORPRESTADOEXERCANT, 0) AS VALORPRESTADOEXERCANT,
       COALESCE(S.VALORPREVISTO, 0) AS VALORPREVISTO,
       COALESCE(S.VALORCONTRAPARTIDA, 0) AS VALORCONTRAPARTIDA,
       S.DATACELEBRACAO,
       S.DATAPRAZOFINAL,
       S.VEICULOPUBLICACAO,
       S.DATAPUBLICACAO,
       S.NREDICAOPUBLICACAO,
       S.CONTADEBITO,
       S.CONTACREDITO,
       S.ANOLEIAUTORIZATORIA,
       S.PROGRAMATICA,
       S.FONTERECURSO,
       COALESCE((SELECT SUM(VALORPAGAMENTO - VALORESTPAGAMENTO + VALORRETENCOES)
          FROM EMPENHO 
         WHERE ENTIDADE     = S.ENTIDADE
           AND EXERCICIO    = S.EXERCICIO
           AND SUBVENCAO    = S.SUBVENCAO
           AND ANOSUBVENCAO = S.ANOSUBVENCAO),0) AS VALORLIBERADO
  FROM SUBVENCAOSOCIAL S  
  JOIN TIPOSUBVENCAO TS  
    ON TS.ID = S.IDTIPO  
  JOIN ENTIDADE E 
    ON E.ENTIDADE = S.ENTIDADE
  LEFT JOIN FORNECEDOR F
    ON F.FORNECEDOR = S.ENTIDADEBENEFICIARIA
 WHERE S.ENTIDADE  = :entidade
   AND S.EXERCICIO = :exercicio