SELECT X.TIPOLANCAMENTO,
       X.DESCRICAOTIPOLANCAMENTO,
       X.EXERCICIOLIQUIDACAO,
       X.NOLIQUIDACAO,
       X.EXERCICIOPAGAMENTO,
       X.NOPAGAMENTO,
       X.DATA,
       X.VALOR,
       X.NRODOCUMENTO
FROM (
SELECT 20 AS TIPOLANCAMENTO,
       'Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Emp: '||E.EMPENHO AS VARCHAR(100)) AS NRODOCUMENTO
FROM EMPENHO E
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 21 AS TIPOLANCAMENTO,
       'Anulação Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Anul:'||E.ANULACAO AS VARCHAR(100)) AS NRODOCUMENTO
FROM ANULACAOEMPENHO E
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 22 AS TIPOLANCAMENTO,
       'Estorno Anulação Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATAESTORNO AS DATA,
       E.VALOR,
       CAST('Ref a Anulação:'||E.ANULACAO AS VARCHAR(100)) AS NRODOCUMENTO
FROM ANULACAOEMPENHO E
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND E.DATAESTORNO IS NOT NULL

UNION ALL
SELECT 21 AS TIPOLANCAMENTO,
       'Cancelamento Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Cancel: '||E.CANCELAMENTORESTOS AS VARCHAR(100)) AS NRODOCUMENTO
FROM CANCELAMENTORESTOS E
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 22 AS TIPOLANCAMENTO,
       'Estorno Cancelamento Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Ref. ao Cancelamento '||E.CANCELAMENTORESTOS AS VARCHAR(100)) AS NRODOCUMENTO
FROM CANCELAMENTORESTOS E
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND E.FLAGESTORNO = 'S'

UNION ALL
SELECT 30 AS TIPOLANCAMENTO,
       'Liquidação ' AS DESCRICAOTIPOLANCAMENTO,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       L.DATA,
       L.VALOR,
       CAST('Liq: '||L.NOLIQUIDACAO||'/'||L.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO
FROM LIQUIDACAO L
LEFT OUTER JOIN EMPENHO E 
  ON L.ENTIDADE = E.ENTIDADE
 AND L.ANODOCORIGEM = E.EXERCICIO
 AND L.NODOCORIGEM = E.EMPENHO
 AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 31 AS TIPOLANCAMENTO,
       'Estorno Liquidação ' AS DESCRICAOTIPOLANCAMENTO,
       L.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       L.DATA,
       L.VALOR,
       CAST('Ref a Liq: '||L.NOLIQUIDACAO||'/'||L.EXERCICIOLIQ AS VARCHAR(100)) AS NRODOCUMENTO
FROM ESTORNOLIQUIDACAO L
LEFT OUTER JOIN EMPENHO E 
  ON L.ENTIDADE = E.ENTIDADE
 AND L.ANODOCORIGEM = E.EXERCICIO
 AND L.NODOCORIGEM = E.EMPENHO
 AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 40 AS TIPOLANCAMENTO,
       --'Pagamento '||' Banco:'||CB.BANCO||' Ag:'||CB.AGENCIA||' Cc:'||CB.CONTA AS DESCRICAOTIPOLANCAMENTO,
       'Pagamento ' AS DESCRICAOTIPOLANCAMENTO,
       PAG.EXERCICIO AS EXERCICIOPAGAMENTO,
       PAG.NOPAGAMENTO,
       A.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       PAG.DATA,
       A.VALOR,
       --CAST(TD.DESCRICAO||' No.'||PAG.NRODOCUMENTO AS VARCHAR(100)) AS NRODOCUMENTO
       CAST('Pagto No. '||PAG.NOPAGAMENTO||'/'||PAG.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO
 FROM PAGAMENTO PAG
 LEFT OUTER JOIN ORDEMPAGAMENTO_LIQUIDACAO A
   ON A.ENTIDADE = PAG.ENTIDADE
  AND A.EXERCICIO = PAG.ANOORDEMPAGAMENTO
  AND A.NOORDEM = PAG.NOORDEMPAGAMENTO
 LEFT OUTER JOIN ORDEMPAGAMENTO OP
   ON A.ENTIDADE = OP.ENTIDADE
  AND A.EXERCICIO = OP.EXERCICIO
  AND A.NOORDEM = OP.NOORDEM
 LEFT OUTER JOIN TIPODOCUMENTO TD
   ON PAG.TIPO = TD.TIPODOCUMENTO
 LEFT OUTER JOIN CONTACORRENTE CC
   ON PAG.ENTIDADE = CC.ENTIDADE
  AND PAG.IDCONTACORRENTE = CC.IDCONTACORRENTE
 LEFT OUTER JOIN CONTABANCARIAVINCULO CBV
   ON CC.ENTIDADE = CBV.ENTIDADE
  AND CC.IDCONTABANCARIAVINCULO = CBV.ID
 LEFT OUTER JOIN CONTABANCARIA CB
   ON PAG.ENTIDADE = CB.ENTIDADE
  AND CBV.REDUZIDO = CB.REDUZIDO
 LEFT OUTER JOIN EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 41 AS TIPOLANCAMENTO,
       'Estorno Pagamento' AS DESCRICAOTIPOLANCAMENTO,
       PAG.EXERCICIO AS EXERCICIOPAGAMENTO,
       PAG.NOPAGAMENTO,
       A.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       EST.DATA,
       EST.VALOR,
       CAST('Ref. ao Pagto No. '||PAG.NOPAGAMENTO||'/'||PAG.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO
FROM ESTORNOPAGAMENTO EST
LEFT OUTER JOIN PAGAMENTO PAG
   ON EST.ENTIDADE = PAG.ENTIDADE
  AND EST.EXERCICIO = PAG.EXERCICIO
  AND EST.NOPAGAMENTO = PAG.NOPAGAMENTO
 LEFT OUTER JOIN ORDEMPAGAMENTO_LIQUIDACAO A
   ON A.ENTIDADE = PAG.ENTIDADE
  AND A.EXERCICIO = PAG.ANOORDEMPAGAMENTO
  AND A.NOORDEM = PAG.NOORDEMPAGAMENTO
 LEFT OUTER JOIN EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho

UNION ALL
SELECT 50 AS TIPOLANCAMENTO,
       'Retenção ' AS DESCRICAOTIPOLANCAMENTO,
       A.EXERCICIO AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       A.DATACONTABILIZADO AS DATA,
       SUM(A.VALOR) AS VALOR,
       --CAST(TD.DESCRICAO||' No.'||PAG.NRODOCUMENTO AS VARCHAR(100)) AS NRODOCUMENTO
       CAST('Retenção Liq. '||A.NOLIQUIDACAO||'/'||A.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO
 FROM RETENCOESLIQUIDACAO A
 LEFT OUTER JOIN EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND A.DATACONTABILIZADO IS NOT NULL
GROUP BY A.EXERCICIO, A.NOLIQUIDACAO, A.DATACONTABILIZADO
 
UNION ALL
SELECT 51 AS TIPOLANCAMENTO,
       'Est Retenção ' AS DESCRICAOTIPOLANCAMENTO,
       A.EXERCICIO AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       A.DATAESTCONTABILIZADO AS DATA,
       SUM(A.VALOR) AS VALOR,
       --CAST(TD.DESCRICAO||' No.'||PAG.NRODOCUMENTO AS VARCHAR(100)) AS NRODOCUMENTO
       CAST('Est Ret Liq. '||A.NOLIQUIDACAO||'/'||A.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO
 FROM RETENCOESLIQUIDACAO A
 LEFT OUTER JOIN EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND A.DATAESTCONTABILIZADO IS NOT NULL
GROUP BY A.EXERCICIO, A.NOLIQUIDACAO, A.DATAESTCONTABILIZADO

) X
ORDER BY X.DATA, X.TIPOLANCAMENTO
