
SELECT D.ENTIDADE,
       D.EXERCICIO,
       D.EMPENHO,
       E.ENTIDADE AS ENTIDADEEMPENHO,
       E.EXERCICIO AS EXERCICIOEMPENHO,
       D.NOLIQUIDACAO AS NUMEROLIQUIDACAO,
       D.UNIDADEORCAMENTARIA,
       F.NOME,
       D.DATASAIDA,
       D.DESTINO,
       D.DATARETORNO,
       D.QTDEDIARIAS AS QUANTIDADEDIARIAS,
       (SELECT SUM(A.VALOR - A.VALORANULACOES + A.VALORESTANULACOES) FROM FICHAEMPENHO A
          WHERE D.ENTIDADE = A.ENTIDADE
            AND D.EXERCICIO = A.EXERCICIO
            AND D.EMPENHO = A.EMPENHO
            AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
       ) AS VALORDIARIAS,
       D.MEIOTRANSPORTE,
       D.VALORPASSAGEM,
       D.MOTIVO,
       D.CARGO,
       E.NOPROCESSO AS NUMEROPROCESSO,
       E.ANOPROCESSO,
       D.LOTACAO,
       D.HORASAIDA,       
       (SELECT SUM(A.VALOR) FROM FICHAEMPENHO A
          WHERE D.ENTIDADE = A.ENTIDADE
            AND D.EXERCICIO = A.EXERCICIO
            AND D.EMPENHO = A.EMPENHO
            AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
       ) AS VALOREMPENHO,
       (SELECT SUM(A.VALORANULACOES - A.VALORESTANULACOES) FROM FICHAEMPENHO A
          WHERE D.ENTIDADE = A.ENTIDADE
            AND D.EXERCICIO = A.EXERCICIO
            AND D.EMPENHO = A.EMPENHO
            AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
       ) AS VALORANULADO,
       (SELECT COUNT(A.EMPENHO)
          FROM FICHAEMPENHO A
         WHERE D.ENTIDADE = A.ENTIDADE
           AND D.EXERCICIO = A.EXERCICIO
           AND D.EMPENHO = A.EMPENHO
           AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
           AND (SELECT SUM(A.VALOR - (A.VALORANULACOES - A.VALORESTANULACOES)) FROM FICHAEMPENHO A
                  WHERE D.ENTIDADE = A.ENTIDADE
                    AND D.EXERCICIO = A.EXERCICIO
                    AND D.EMPENHO = A.EMPENHO
                    AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
               ) < 0.01
       ) AS QUANTIDADEANULACOES,
       ORC.DESCRICAO AS SECRETARIA,
       CASE 
          WHEN P.VALOR = 'N' THEN 'Nome do Proponente'
          WHEN P.VALOR = 'C' THEN 'Cargo do Beneficiado'
          ELSE 'Cargo do Proponente'
       END AS LABELCARGO,
       D.IDTIPOOBJETIVODIARIA,
       T.DSTIPOOBJETIVODIARIA AS TIPOOBJETIVODIARIA,
       D.VLRHOSPEDAGEM AS VALORHOSPEDAGEM,
       D.VLREVENTO AS VALOREVENTO
  FROM DIARIA D
  LEFT OUTER JOIN EMPENHO E
    ON D.ENTIDADE = E.ENTIDADE
   AND D.EXERCICIO = E.EXERCICIO
   AND D.EMPENHO = E.EMPENHO
   AND D.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
  LEFT OUTER JOIN FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT OUTER JOIN ORCPARAMETRODESPESA ORC
    ON ORC.CODIGO = SUBSTR(E.PROGRAMATICA,1, 5)
   AND ORC.ENTIDADE = E.ENTIDADE
   AND ORC.EXERCICIO = E.EXERCICIO
  LEFT OUTER JOIN PARAMETROS P
    ON P.ENTIDADE = D.ENTIDADE
   AND P.EXERCICIO = D.EXERCICIO
   AND P.MODULO = '3'
   AND P.CODIGO = 159
  LEFT JOIN TIPOOBJETIVODIARIA T
    ON T.ID = D.IDTIPOOBJETIVODIARIA   
  LEFT JOIN LIQUIDACAO L
    ON L.ENTIDADE = E.ENTIDADE
   AND L.EXERCICIO = E.EXERCICIO
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
   AND L.NOLIQUIDACAO = D.NOLIQUIDACAO
 WHERE D.ENTIDADE = :entidade
   AND D.EXERCICIO = :exercicio
   AND ((L.VALOR - L.VALORESTLIQUIDACAO) > 0 OR L.VALOR IS NULL)