SELECT RDC.DESCRICAO AS NATUREZA, COUNT(*) AS TOTAL
  FROM RHFUNCIONARIO F 
  LEFT OUTER JOIN PESSOA P
    ON F.PESSOA = P.PESSOA
  LEFT OUTER JOIN RHCARGO C 
    ON F.ENTIDADE = C.ENTIDADE 
   AND F.CARGO = C.CARGO 
  LEFT OUTER JOIN RHCLASSE CL 
    ON F.ENTIDADE = CL.ENTIDADE 
   AND F.CLASSE = CL.CLASSE 
  LEFT OUTER JOIN RHDEFINICAOCLASSE RDC 
    ON CL.DEFINICAO = RDC.DEFINICAO 
  LEFT OUTER JOIN RHLOTACAO RL 
    ON F.ENTIDADE = RL.ENTIDADE 
   AND F.MODELOLOTACAO = RL.MODELOLOTACAO 
   AND F.NIVELLOTACAO = RL.NIVELLOTACAO 
   AND F.LOTACAO = RL.LOTACAO 
  LEFT OUTER JOIN RHMOVIMENTACAOPESSOAL MP
    ON F.ENTIDADE = MP.ENTIDADE
   AND F.MATRICULA = MP.MATRICULA
   AND MP.TIPOMOVIMENTACAO IN (32)
  LEFT OUTER JOIN RHMOVIMENTACAOAFASTAMENTO MA
    ON MP.MOVIMENTACAO = MA.MOVIMENTACAO
   AND MP.ENTIDADE = MA.ENTIDADE
   AND MA.DATAINICIAL <= :dataAtual
   AND (MA.DATAFINAL IS NULL OR MA.DATAFINAL > :dataAtual) 
 WHERE F.ENTIDADE = :entidade
   AND ((F.SITUACAO = 2 AND MA.VACANCIA = 'S' AND MA.MOVIMENTACAO > 0) 
       OR F.SITUACAO <> 3 AND MA.MOVIMENTACAO IS NULL) 