/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.Veiculo;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoManutencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoListDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.VeiculoToDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.VeiculoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.VeiculoParams;
import br.com.elotech.portaltransparencia.contabportal.service.VeiculoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class VeiculoServiceImpl
implements VeiculoService {
    private static final long PARAMETRO_TIPO_GASTO = 23L;
    private final VeiculoRepository veiculoRepository;
    private final PortalParametroService portalParametroService;
    private final EntityManager em;

    @Autowired
    public VeiculoServiceImpl(VeiculoRepository veiculoRepository, @Qualifier(value="entityManager") EntityManager em, PortalParametroService portalParametroService) {
        this.veiculoRepository = veiculoRepository;
        this.em = em;
        this.portalParametroService = portalParametroService;
    }

    public Page<VeiculoListDTO> findByEntidade(Long entidade, String search, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder();
        searchBuilder.append(" (id.entidade==").append(entidade);
        searchBuilder.append(" or bem.compartilha=='S')");
        searchBuilder.append(" and id.tipo=='V'");
        if (Objects.nonNull(search)) {
            searchBuilder.append(" and ");
            searchBuilder.append(search);
        }
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.em, Veiculo.class, (String)searchBuilder.toString());
        return this.veiculoRepository.findAll(specification, pageable).map((Function)new VeiculoToDTO());
    }

    public List<VeiculoGastoDTO> getGastosVeiculo(VeiculoParams params) {
        if (this.validarParametros(params)) {
            String tipoGasto = this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Long.valueOf(23L));
            return this.veiculoRepository.getGastosVeiculo(params, tipoGasto);
        }
        return new ArrayList<VeiculoGastoDTO>();
    }

    private boolean validarParametros(VeiculoParams params) {
        return Objects.nonNull(params) && Objects.nonNull(params.getEntidade()) && Objects.nonNull(params.getExercicio()) && Objects.nonNull(params.getVeiculo());
    }

    public List<PatrimonioAlienacao> findAlienacoes() {
        return this.veiculoRepository.findAlienacoes();
    }

    public VeiculoDTO findVeiculo(VeiculoParams params) {
        return this.veiculoRepository.findVeiculo(params);
    }

    public List<VeiculoGastoManutencaoDTO> findGastosManutencaoByVeiculo(VeiculoParams params) {
        return this.veiculoRepository.findGastosManutencaoByVeiculo(params);
    }
}

