/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.UltimaAtualizacaoCustom;
import br.com.elotech.portaltransparencia.contabportal.service.IntegradoComUnicoService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class UltimaAtualizacaoRepository
implements UltimaAtualizacaoCustom {
    private final JdbcTemplate jdbcTemplate;
    private final IntegradoComUnicoService integradoComUnicoService;

    @Autowired
    public UltimaAtualizacaoRepository(@Qualifier(value="dataSource") DataSource dataSource, IntegradoComUnicoService integradoComUnicoService) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.integradoComUnicoService = integradoComUnicoService;
    }

    public List<UltimaAtualizacaoDTO> ultimaAtualizacao() {
        StringBuilder sql = new StringBuilder();
        if (!this.integradoComUnicoService.isIntegradoComUnico()) {
            sql.append("SELECT MODULO, MAX(ULTIMOACESSO) AS ULTIMOACESSO FROM USRXMOD ");
            sql.append("\n WHERE ULTIMOACESSO IS NOT NULL ");
            sql.append("\n GROUP BY MODULO");
            return this.jdbcTemplate.query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
        }
        sql.append("SELECT MODULO, (SELECT MAX(ULTIMOACESSO) FROM USRXMOD) AS ULTIMOACESSO ");
        sql.append("\n FROM USRXMOD ");
        sql.append("\n WHERE ULTIMOACESSO IS NOT NULL ");
        sql.append("\n GROUP BY MODULO");
        sql.append("\n ORDER BY MODULO");
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }

    public UltimaAtualizacaoDTO getUltimaAtualizacao(String table, String column) {
        List listResult = this.jdbcTemplate.query(SqlUtils.createSQLUltimaAtualizacaoByTableAndColumn((String)table, (String)column), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
        return listResult.stream().findFirst().orElse(new UltimaAtualizacaoDTO());
    }
}

