/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBemArquivo;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBemPK;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioImovel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="PAT_BEM")
public class PatrimonioBem
implements EloEntity<PatrimonioBemPK>,
Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private PatrimonioBemPK id;
    private BigDecimal valorAtual;
    @Length(max=50)
    private @Length(max=50) String localAtual;
    @Length(max=2000)
    private @Length(max=2000) String descricao;
    @Length(max=1)
    @Convert(converter=BooleanToStringConverter.class)
    private @Length(max=1) Boolean baixado;
    @Column(name="DATAAQUISICAO")
    private LocalDate dataAquisicao;
    @Column(name="DATABAIXA")
    private LocalDate dataBaixa;
    @Transient
    private String justificativa;
    @ManyToOne
    private PatrimonioAlienacao incorporacao;
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", insertable=false, updatable=false), @JoinColumn(name="tipo", referencedColumnName="tipo", insertable=false, updatable=false), @JoinColumn(name="bem", referencedColumnName="bem", insertable=false, updatable=false), @JoinColumn(name="chapa", referencedColumnName="chapa", insertable=false, updatable=false)})
    private PatrimonioImovel imovel;
    private Long notaFiscal;
    @Column(name="COMPARTILHA_ENTSN")
    @Length(max=1)
    private @Length(max=1) String compartilha;
    @OneToMany(mappedBy="id.bem")
    private final List<PatrimonioBemArquivo> arquivos = new ArrayList();
    @Column(name="PLAQUETAANT")
    @Length(max=20)
    private @Length(max=20) String numeroFrota;

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatrimonioBem)) {
            return false;
        }
        PatrimonioBem other = (PatrimonioBem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PatrimonioBemPK this$id = this.getId();
        PatrimonioBemPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatrimonioBem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PatrimonioBemPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public PatrimonioBem() {
    }

    @Generated
    public PatrimonioBemPK getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getValorAtual() {
        return this.valorAtual;
    }

    @Generated
    public String getLocalAtual() {
        return this.localAtual;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getBaixado() {
        return this.baixado;
    }

    @Generated
    public LocalDate getDataAquisicao() {
        return this.dataAquisicao;
    }

    @Generated
    public LocalDate getDataBaixa() {
        return this.dataBaixa;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public PatrimonioAlienacao getIncorporacao() {
        return this.incorporacao;
    }

    @Generated
    public PatrimonioImovel getImovel() {
        return this.imovel;
    }

    @Generated
    public Long getNotaFiscal() {
        return this.notaFiscal;
    }

    @Generated
    public String getCompartilha() {
        return this.compartilha;
    }

    @Generated
    public List<PatrimonioBemArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public String getNumeroFrota() {
        return this.numeroFrota;
    }

    @Generated
    public void setId(PatrimonioBemPK id) {
        this.id = id;
    }

    @Generated
    public void setValorAtual(BigDecimal valorAtual) {
        this.valorAtual = valorAtual;
    }

    @Generated
    public void setLocalAtual(String localAtual) {
        this.localAtual = localAtual;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setBaixado(Boolean baixado) {
        this.baixado = baixado;
    }

    @Generated
    public void setDataAquisicao(LocalDate dataAquisicao) {
        this.dataAquisicao = dataAquisicao;
    }

    @Generated
    public void setDataBaixa(LocalDate dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public void setIncorporacao(PatrimonioAlienacao incorporacao) {
        this.incorporacao = incorporacao;
    }

    @Generated
    public void setImovel(PatrimonioImovel imovel) {
        this.imovel = imovel;
    }

    @Generated
    public void setNotaFiscal(Long notaFiscal) {
        this.notaFiscal = notaFiscal;
    }

    @Generated
    public void setCompartilha(String compartilha) {
        this.compartilha = compartilha;
    }

    @Generated
    public void setNumeroFrota(String numeroFrota) {
        this.numeroFrota = numeroFrota;
    }

    @Generated
    public String toString() {
        return "PatrimonioBem(id=" + this.getId() + ", valorAtual=" + this.getValorAtual() + ", localAtual=" + this.getLocalAtual() + ", descricao=" + this.getDescricao() + ", baixado=" + this.getBaixado() + ", dataAquisicao=" + this.getDataAquisicao() + ", dataBaixa=" + this.getDataBaixa() + ", justificativa=" + this.getJustificativa() + ", incorporacao=" + this.getIncorporacao() + ", imovel=" + this.getImovel() + ", notaFiscal=" + this.getNotaFiscal() + ", compartilha=" + this.getCompartilha() + ", arquivos=" + this.getArquivos() + ", numeroFrota=" + this.getNumeroFrota() + ")";
    }
}

