/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.contabportal.resource.params.VeiculoParams;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class VeiculoParams {
    private Long entidade;
    private Long exercicio;
    private Long veiculo;
    private String chapa;
    private int mes;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addVeiculo(params);
        this.addChapa(params);
        this.addDataInicio(params);
        this.addDataFim(params);
        return params;
    }

    private void addVeiculo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.veiculo)) {
            params.addValue("veiculo", (Object)this.veiculo, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addChapa(MapSqlParameterSource params) {
        if (Objects.nonNull(this.chapa)) {
            params.addValue("chapa", (Object)this.chapa, 12);
        }
    }

    private void addDataInicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio) && NumberUtils.isBiggerThanZero((Number)this.mes).booleanValue()) {
            params.addValue("dataInicio", (Object)this.dateFormated(DateUtils.firstDayOfMonth((int)this.mes, (int)this.exercicio.intValue())), 91);
        }
    }

    private void addDataFim(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio) && NumberUtils.isBiggerThanZero((Number)this.mes).booleanValue()) {
            params.addValue("dataFim", (Object)this.dateFormated(DateUtils.lastDayOfMonth((int)this.mes, (int)this.exercicio.intValue())), 91);
        }
    }

    private String dateFormated(LocalDate data) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy'-'MM'-'dd", Locale.getDefault());
        return df.format(Date.from(data.atStartOfDay(ZoneId.systemDefault()).toInstant()));
    }

    @Generated
    public static VeiculoParamsBuilder builder() {
        return new VeiculoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "VeiculoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", veiculo=" + this.getVeiculo() + ", chapa=" + this.getChapa() + ", mes=" + this.getMes() + ")";
    }

    @Generated
    public VeiculoParams() {
    }

    @Generated
    public VeiculoParams(Long entidade, Long exercicio, Long veiculo, String chapa, int mes) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.veiculo = veiculo;
        this.chapa = chapa;
        this.mes = mes;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getVeiculo() {
        return this.veiculo;
    }

    @Generated
    public String getChapa() {
        return this.chapa;
    }

    @Generated
    public int getMes() {
        return this.mes;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setVeiculo(Long veiculo) {
        this.veiculo = veiculo;
    }

    @Generated
    public void setChapa(String chapa) {
        this.chapa = chapa;
    }

    @Generated
    public void setMes(int mes) {
        this.mes = mes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VeiculoParams)) {
            return false;
        }
        VeiculoParams other = (VeiculoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$veiculo = this.getVeiculo();
        Long other$veiculo = other.getVeiculo();
        if (this$veiculo == null ? other$veiculo != null : !((Object)this$veiculo).equals(other$veiculo)) {
            return false;
        }
        String this$chapa = this.getChapa();
        String other$chapa = other.getChapa();
        if (this$chapa == null ? other$chapa != null : !this$chapa.equals(other$chapa)) {
            return false;
        }
        return this.getMes() == other.getMes();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VeiculoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $veiculo = this.getVeiculo();
        result = result * 59 + ($veiculo == null ? 43 : ((Object)$veiculo).hashCode());
        String $chapa = this.getChapa();
        result = result * 59 + ($chapa == null ? 43 : $chapa.hashCode());
        result = result * 59 + this.getMes();
        return result;
    }
}

