/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class FindReceitaParams {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private Long entidade;
    private Long exercicio;
    private Integer diasRetroativo;
    private Integer mesDiasRetroativos;
    private String receita;
    private Long numeroDias;
    private String data;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;
    private String exportType;

    public Integer getMesDiasRetroativos() {
        if (Objects.isNull(this.numeroDias)) {
            this.setNumeroDias(Long.valueOf(0L));
        }
        return FindReceitaParams.getMesDiasRetroativos((int)this.numeroDias.intValue());
    }

    public Optional<String> getReceita() {
        return Optional.ofNullable(this.receita);
    }

    public Optional<Long> getNumeroDias() {
        return Optional.ofNullable(this.numeroDias);
    }

    public Optional<LocalDate> getDataInicial() {
        return Optional.ofNullable(this.dataInicial);
    }

    public Optional<LocalDate> getDataFinal() {
        return Optional.ofNullable(this.dataFinal);
    }

    public MapSqlParameterSource toJdbcParameter(int tamanho) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addDiasRetroativo(params);
        this.addMesDiasRetroativos(params);
        this.addReceita(params, tamanho);
        this.addNumeroDias(params);
        this.addTamanho(params, tamanho);
        this.addData(params);
        this.addDataInicial(params);
        this.addDataFinal(params);
        return params;
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addReceita(MapSqlParameterSource params, int tamanho) {
        if (Objects.nonNull(this.receita)) {
            params.addValue("receita", (Object)StringUtils.rightPad((String)this.receita, (int)tamanho, (String)"0"), 12);
        }
    }

    private void addDiasRetroativo(MapSqlParameterSource params) {
        if (Objects.isNull(this.numeroDias)) {
            this.setNumeroDias(Long.valueOf(0L));
        }
        params.addValue("diasRetroativo", (Object)FindReceitaParams.toSQLDateDiasRetroativoString((int)this.numeroDias.intValue()), 91);
    }

    private void addMesDiasRetroativos(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroDias)) {
            params.addValue("mesDiasRetroativos", (Object)this.mesDiasRetroativos, 2);
        }
    }

    private void addNumeroDias(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroDias)) {
            params.addValue("numeroDias", (Object)FindReceitaParams.toSQLDateDiasRetroativoString((int)this.numeroDias.intValue()), 91);
        }
    }

    private void addTamanho(MapSqlParameterSource params, int tamanho) {
        if (Objects.nonNull(tamanho)) {
            params.addValue("tamanho", (Object)tamanho, 2);
        }
    }

    private void addData(MapSqlParameterSource params) {
        if (Objects.nonNull(this.data)) {
            params.addValue("data", (Object)this.data, 91);
        }
    }

    public static String toSQLDateDiasRetroativoString(int diasRetroativo) {
        LocalDate data = LocalDate.now().minus(diasRetroativo, ChronoUnit.DAYS);
        return data.format(DATE_FORMAT);
    }

    public static int getMesDiasRetroativos(int diasRetroativo) {
        LocalDate data = LocalDate.now().minus(diasRetroativo, ChronoUnit.DAYS);
        return data.getMonthValue();
    }

    private void addDataInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)this.dataInicial.format(DATE_FORMAT), 91);
        }
    }

    private void addDataFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)this.dataFinal.format(DATE_FORMAT), 91);
        }
    }

    @Generated
    public static FindReceitaParamsBuilder builder() {
        return new FindReceitaParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindReceitaParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", diasRetroativo=" + this.getDiasRetroativo() + ", mesDiasRetroativos=" + this.getMesDiasRetroativos() + ", receita=" + this.getReceita() + ", numeroDias=" + this.getNumeroDias() + ", data=" + this.getData() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public FindReceitaParams() {
    }

    @Generated
    public FindReceitaParams(Long entidade, Long exercicio, Integer diasRetroativo, Integer mesDiasRetroativos, String receita, Long numeroDias, String data, LocalDate dataInicial, LocalDate dataFinal, String exportType) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.diasRetroativo = diasRetroativo;
        this.mesDiasRetroativos = mesDiasRetroativos;
        this.receita = receita;
        this.numeroDias = numeroDias;
        this.data = data;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.exportType = exportType;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Integer getDiasRetroativo() {
        return this.diasRetroativo;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDiasRetroativo(Integer diasRetroativo) {
        this.diasRetroativo = diasRetroativo;
    }

    @Generated
    public void setMesDiasRetroativos(Integer mesDiasRetroativos) {
        this.mesDiasRetroativos = mesDiasRetroativos;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setNumeroDias(Long numeroDias) {
        this.numeroDias = numeroDias;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindReceitaParams)) {
            return false;
        }
        FindReceitaParams other = (FindReceitaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Integer this$diasRetroativo = this.getDiasRetroativo();
        Integer other$diasRetroativo = other.getDiasRetroativo();
        if (this$diasRetroativo == null ? other$diasRetroativo != null : !((Object)this$diasRetroativo).equals(other$diasRetroativo)) {
            return false;
        }
        Integer this$mesDiasRetroativos = this.getMesDiasRetroativos();
        Integer other$mesDiasRetroativos = other.getMesDiasRetroativos();
        if (this$mesDiasRetroativos == null ? other$mesDiasRetroativos != null : !((Object)this$mesDiasRetroativos).equals(other$mesDiasRetroativos)) {
            return false;
        }
        Optional this$receita = this.getReceita();
        Optional other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !((Object)this$receita).equals(other$receita)) {
            return false;
        }
        Optional this$numeroDias = this.getNumeroDias();
        Optional other$numeroDias = other.getNumeroDias();
        if (this$numeroDias == null ? other$numeroDias != null : !((Object)this$numeroDias).equals(other$numeroDias)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Optional this$dataInicial = this.getDataInicial();
        Optional other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        Optional this$dataFinal = this.getDataFinal();
        Optional other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindReceitaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Integer $diasRetroativo = this.getDiasRetroativo();
        result = result * 59 + ($diasRetroativo == null ? 43 : ((Object)$diasRetroativo).hashCode());
        Integer $mesDiasRetroativos = this.getMesDiasRetroativos();
        result = result * 59 + ($mesDiasRetroativos == null ? 43 : ((Object)$mesDiasRetroativos).hashCode());
        Optional $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : ((Object)$receita).hashCode());
        Optional $numeroDias = this.getNumeroDias();
        result = result * 59 + ($numeroDias == null ? 43 : ((Object)$numeroDias).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Optional $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        Optional $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }
}

