/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.ContatoResponsavel;
import br.com.elotech.portaltransparencia.contabportal.service.ContatoResponsavelService;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contato-responsaveis", "/admin/api/contato-responsaveis"})
public class ContatoResponsavelResource {
    private final ContatoResponsavelService service;

    @Autowired
    public ContatoResponsavelResource(ContatoResponsavelService service) {
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<ContatoResponsavel>> listContatos(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.service.findContatosPorEntidadeExercicio(entidade, exercicio));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ContatoResponsavel> findOne(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.service.findContato(id));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<ContatoResponsavel> update(@RequestBody ContatoResponsavel contato, @PathVariable(value="id") Long id) {
        contato.setId(id);
        ContatoResponsavel updated = this.service.saveContatos(contato);
        return ResponseEntity.ok((Object)updated);
    }

    @PostMapping
    public ResponseEntity<ContatoResponsavel> saveContato(@RequestBody ContatoResponsavel contatoResponsavel) {
        return ResponseEntity.ok((Object)this.service.saveContatos(contatoResponsavel));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<ContatoResponsavel> deleteContato(@PathVariable(value="id") Long id) {
        ContatoResponsavel contato = this.service.findContato(id);
        if (Objects.isNull(contato)) {
            return ResponseEntity.notFound().build();
        }
        this.service.deleteContatos(contato);
        return ResponseEntity.ok().build();
    }
}

