/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ObjetivoEstrategicoArqDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ObjetivoEstrategicoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ObjetivoEstrategicoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.ObjetivoEstrategicoParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ObjetivoEstrategicoRespositoryImpl
implements ObjetivoEstrategicoRepository {
    private final DatasourceWrapper datasourceWrapper;
    private static final String OBJETIVO_ESTRATEGICO = "db/sql/contab/objetivo_estrategico.sql";
    private static final String OBJETIVO_ESTRATEGICO_ARQ = "db/sql/contab/objetivo_estrategico_arq.sql";

    @Autowired
    public ObjetivoEstrategicoRespositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<ObjetivoEstrategicoDTO> findObjetivoEstrategico(ObjetivoEstrategicoParams params) {
        String sql = FileUtils.readResourceAsString((String)OBJETIVO_ESTRATEGICO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObjetivoEstrategicoDTO.class));
    }

    public List<ObjetivoEstrategicoArqDTO> findObjetivoEstrategicoArq(ObjetivoEstrategicoParams params) {
        String sql = FileUtils.readResourceAsString((String)OBJETIVO_ESTRATEGICO_ARQ);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObjetivoEstrategicoArqDTO.class));
    }
}

