/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ItemEstoqueDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ItemEstoqueRepository;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.ItemEstoqueParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ItemEstoqueRepositoryImpl
implements ItemEstoqueRepository {
    private static final String ESTOQUE_SQL = "db/sql/contab/estoque.sql";
    private final DatasourceWrapper datasourceWrapper;

    public ItemEstoqueRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<ItemEstoqueDTO> findItemEstoque(ItemEstoqueParams params, Pageable pageable) {
        if (!this.validarParams(params)) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)ESTOQUE_SQL));
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY ITEMDESCRICAO, UNIDADE ");
        String query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List itens = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ItemEstoqueDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getCount(sql.toString()), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(itens, pageable, total.longValue());
    }

    private String getCount(String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return sqlCount.toString();
    }

    private boolean validarParams(ItemEstoqueParams params) {
        return Objects.nonNull(params.getEntidade()) && Objects.nonNull(params.getCentroCusto());
    }
}

