/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="wrapperContabilidade")
public class DatasourceWrapperContabilidade
implements DatasourceWrapper {
    private final DataSource dataSource;
    private final DBConfigProperties dbConfigProperties;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DatasourceWrapperContabilidade(@Qualifier(value="dataSource") DataSource dataSource, DBConfigProperties dbConfigProperties) {
        this.dataSource = dataSource;
        this.dbConfigProperties = dbConfigProperties;
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getPlatform() {
        return this.dbConfigProperties.getContabilidade().getPlatform();
    }

    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }
}

