/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.portaltransparencia.config.DBUnitAiseConfig;
import br.com.elotech.portaltransparencia.config.DBUnitArquivoConfig;
import br.com.elotech.portaltransparencia.config.DBUnitComprasConfig;
import br.com.elotech.portaltransparencia.config.DBUnitContabilidadeConfig;
import br.com.elotech.portaltransparencia.config.DBUnitProtocoloConfig;
import com.github.springtestdbunit.bean.DatabaseConfigBean;
import com.github.springtestdbunit.bean.DatabaseDataSourceConnectionFactoryBean;
import com.github.springtestdbunit.dataset.FlatXmlDataSetLoader;
import java.util.Collections;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.boot.CommandLineRunner;

public class DatabaseLoader
implements CommandLineRunner {
    private final DataSource dataSource;
    private final DatabaseConfigBean databaseConfigBean;

    public DatabaseLoader(DataSource dataSource, DatabaseConfigBean databaseConfigBean) {
        this.dataSource = dataSource;
        this.databaseConfigBean = databaseConfigBean;
    }

    public void run(String ... args) {
        String[] dbUnit = (String[])Stream.of(this.getDBUnitAise(), this.getDBUnitArquivo(), this.getDBUnitContabilidade(), this.getDBUnitCompras(), this.getDBUnitProtocolo()).flatMap(Stream::of).toArray(String[]::new);
        this.loadDBUnitDatasets(DatabaseOperation.INSERT, dbUnit);
    }

    private String[] getDBUnitAise() {
        return DBUnitAiseConfig.getConfig();
    }

    private String[] getDBUnitArquivo() {
        return DBUnitArquivoConfig.getConfig();
    }

    private String[] getDBUnitContabilidade() {
        return DBUnitContabilidadeConfig.getConfig();
    }

    private String[] getDBUnitCompras() {
        return DBUnitComprasConfig.getConfig();
    }

    private String[] getDBUnitProtocolo() {
        return DBUnitProtocoloConfig.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDBUnitDatasets(DatabaseOperation databaseOperation, String ... datasets) {
        IDatabaseConnection connection = DatabaseDataSourceConnectionFactoryBean.newConnection((DataSource)this.dataSource);
        try {
            this.databaseConfigBean.apply(connection.getConfig());
            FlatXmlDataSetLoader dataSetLoader = new FlatXmlDataSetLoader();
            for (String datasetName : datasets) {
                IDataSet dataSet = dataSetLoader.loadDataSet(this.getClass(), datasetName);
                if (dataSet == null) {
                    throw new IllegalArgumentException(String.format("[[[ O dataset com nome [%s] n\u00e3o foi encontrado, verifique a configura\u00e7\u00e3o nas classes com o nome DBUnit**Config.java ]]]", datasetName));
                }
                databaseOperation.execute(connection, dataSet);
            }
        }
        finally {
            if (Collections.singletonList(connection).get(0) != null) {
                connection.close();
            }
        }
    }
}

