/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AditivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.TipoContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.ContratoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.ContratoService;
import br.com.elotech.portaltransparencia.exception.ContratoNaoEncontradoException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ContratoServiceImpl
implements ContratoService {
    private final ContratoRepository contratoRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public ContratoServiceImpl(ContratoRepository contratoRepository, ArquivoService arquivoService) {
        this.contratoRepository = contratoRepository;
        this.arquivoService = arquivoService;
    }

    public Page<ContratoDTO> findContratos(FindContratoParams findContratoParams, Pageable pageable) {
        return this.contratoRepository.findContratos(findContratoParams, pageable);
    }

    public List<AditivoDTO> findAditivos(FindContratoParams findContratoParams) {
        return this.contratoRepository.findAditivos(findContratoParams);
    }

    public ContratoDTO findContrato(FindContratoParams findContratoParams) {
        return this.contratoRepository.findContrato(findContratoParams);
    }

    public List<TipoContratoDTO> findTiposContrato(String uf) {
        return this.contratoRepository.findTiposContrato(uf);
    }

    public List<ContratoDTO> findContratosLicitacao(FindContratoParams findContratoParams) {
        return this.contratoRepository.findContratosLicitacao(findContratoParams);
    }

    public ContratoDTO findContratoByIdContrato(FindContratoParams findContratoParams) {
        try {
            return this.contratoRepository.findContratoByIdContrato(findContratoParams);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ContratoNaoEncontradoException("Contrato n\u00e3o encontrado", (Throwable)e);
        }
    }

    public List<ContratoArquivoDTO> findArquivos(FindContratoParams params) {
        return this.contratoRepository.findArquivos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }
}

